package cz.fidentis.analyst.core;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.canvas.toolbar.SceneToolboxSingleFace;
import cz.fidentis.analyst.batch.BatchAction;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.windows.TopComponent;

/**
 * A non-singleton window/tab for the batch N:N analysis.
 *
 * @author Radek Oslejsek
 */
public class ManyToManyTab extends TopComponent {
    
    private final Canvas canvas ;
    private final TopControlPanel controlPanel;
    private final JScrollPane scrollPane;
    
    /**
     * Constructor.
     * 
     * @param name Tab name
     */
    public ManyToManyTab(String name) {
        canvas = new Canvas();
        //canvas.initScene(faces.get(0)); // !!!
        canvas.addToolBox(new SceneToolboxSingleFace(canvas)); // !!!
        controlPanel = new TopControlPanel();
        
        scrollPane = new JScrollPane(controlPanel);
        
        setName(name);
        initComponents();
        
        // change the height so that it corresponds to the height of the OpenGL window
        canvas.addComponentListener(new ComponentAdapter() {
            @Override
            public void componentResized(ComponentEvent e) {
                scrollPane.setSize(ControlPanel.CONTROL_PANEL_WIDTH, canvas.getHeight());
            }
        });
        
        // (Re)render scene after all change listeners have been called
        // (the first added listener is called last)
        controlPanel.addChangeListener(e -> canvas.renderScene());
        new BatchAction(canvas, controlPanel);
        //new DistanceAction(canvas, controlPanel);
        //new SymmetryAction(canvas, controlPanel);
        //new ProfilesAction(canvas, controlPanel);
    }
    
    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(canvas, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
//                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addComponent(
                                        scrollPane,
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH
                                )
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(canvas)
//                                        .addComponent(renderingToolBar)
                                        .addComponent(scrollPane)
                                ))
        );
    }
}
