package cz.fidentis.analyst.batch;

import cz.fidentis.analyst.core.ProgressDialog;
import javax.swing.SwingWorker;

/**
 * A task that computes similarity of the set of faces.
 * 
 * @author Radek Oslejsek
 */
public abstract class SimilarityTask extends SwingWorker<Void, Integer> {
    
    private final ProgressDialog progressDialog;
    private final BatchPanel controlPanel;
    
    private double[][] similarities;
    
    /**
     * Constructor.
     * 
     * @param progressDialog A window that show the progress of the computation. Must not be {@code null}
     * @param controlPanel A control panel with computation parameters. Must not be {@code null}
     */
    public SimilarityTask(ProgressDialog progressDialog, BatchPanel controlPanel) {
        this.progressDialog = progressDialog;
        this.controlPanel = controlPanel;
        int nFaces = getControlPanel().getFaces().size();
        similarities = new double[nFaces][nFaces];
    }
    
    @Override
    protected void done() {
        progressDialog.dispose(); // close progess bar
        if (isCancelled()) {
            similarities = null;
        }
    }
    
    /**
     * Returns computed 2D matrix od similarities or {@code null}
     * @return computed 2D matrix od similarities or {@code null}
     */
    public double[][] getSimilarities() {
        return similarities;
    }

    public ProgressDialog getProgressDialog() {
        return progressDialog;
    }

    public BatchPanel getControlPanel() {
        return controlPanel;
    }
    
    protected void setSimilarity(int i, int j, double val) {
        similarities[i][j] = val;
    }
}
