package cz.fidentis.analyst.symmetry;

import cz.fidentis.analyst.core.ControlPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.DoubleSummaryStatistics;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/**
 * Control panel for symmetry plane.
 *
 * @author Natalia Bebjakova
 * @author Radek Oslejsek
 */
public class SymmetryPanel extends ControlPanel  {
    
    /*
     * Handled actions
     */
    public static final String ACTION_COMMAND_RECOMPUTE_FROM_MESH = "From triangular mesh";
    public static final String ACTION_COMMAND_COMPUTE_FROM_FPS = "From feature points";
    
    /*
     * Mandatory design elements
     */
    public static final String ICON = "symmetry28x28.png";
    public static final String NAME = "Symmetry";
    
    /*
     * Configuration of panel-specific GUI elements
     */
    public static final int MAX_SIGNIFICANT_POINTS = 500;
    
    /*
     * Computational state
     */
    private SymmetryConfig config = new SymmetryConfig();

    /**
     * Creates new form SymmetryPanelNew
     */
    public SymmetryPanel(ActionListener action) {
        this.setName(NAME);
        initComponents();
        
        comboSliderInteger1.setRange(0, MAX_SIGNIFICANT_POINTS);
        comboSliderInteger1.setValue(config.getSignificantPointCount());
        comboSliderInteger1.setSliderEast();
        comboSliderInteger1.addInputFieldListener(
                (ActionEvent e) -> { 
                    config.setSignificantPointCount(comboSliderInteger1.getValue());
                }
        );
        
        comboSliderDouble1.setRange(0, 1, 3);
        comboSliderDouble1.setSliderEast();
        comboSliderDouble1.setValue(config.getMinCurvRatio());
        comboSliderDouble1.addInputFieldListener(
                (ActionEvent e) -> { 
                    config.setMinCurvRatio(comboSliderDouble1.getValue());
                }
        );
        
        comboSliderDouble2.setRange(0, 1, 3);
        comboSliderDouble2.setSliderEast();
        comboSliderDouble2.setValue(config.getMinAngleCos());
        comboSliderDouble2.addInputFieldListener(
                (ActionEvent e) -> { 
                    config.setMinAngleCos(comboSliderDouble2.getValue());
                }
        );
        
        comboSliderDouble3.setRange(0, 1, 3);
        comboSliderDouble3.setSliderEast();
        comboSliderDouble3.setValue(config.getMinNormAngleCos());
        comboSliderDouble3.addInputFieldListener(
                (ActionEvent e) -> { 
                    config.setMinNormAngleCos(comboSliderDouble3.getValue());
                }
        );
        
        comboSliderDouble4.setRange(0, 1, 2);
        comboSliderDouble4.setSliderEast();
        comboSliderDouble4.setValue(config.getMaxRelDistance());
        comboSliderDouble4.addInputFieldListener(
                (ActionEvent e) -> { 
                    config.setMaxRelDistance(comboSliderDouble4.getValue());
                }
        );
        
        jButton1.addActionListener(
                (ActionEvent e) -> {
                    config = new SymmetryConfig();
                    comboSliderInteger1.setValue(config.getSignificantPointCount());
                    comboSliderDouble1.setValue(config.getMinCurvRatio());
                    comboSliderDouble2.setValue(config.getMinAngleCos());
                    comboSliderDouble3.setValue(config.getMinNormAngleCos());
                    comboSliderDouble4.setValue(config.getMaxRelDistance());
                    //setConfig(new SymmetryConfig());
                }
        );
        
        jButton2.addActionListener((ActionEvent e) -> { 
                    action.actionPerformed(new ActionEvent( // recompute
                            e.getSource(), 
                            ActionEvent.ACTION_PERFORMED,
                            jComboBox1.getSelectedItem().toString()
                    )); 
                }
        );
        
        jButtonInfo1.addActionListener(
                (ActionEvent e) -> { 
                    this.showSignPointsHelp();
                }
        );
        
        jButtonInfo2.addActionListener(
                (ActionEvent e) -> { 
                    this.showMinCurvHelp();
                }
        );
        
        jButtonInfo3.addActionListener(
                (ActionEvent e) -> { 
                    this.showMinAngleCosHelp();
                }
        );
        
        jButtonInfo4.addActionListener(
                (ActionEvent e) -> { 
                    this.showNormalAngleHelp();
                }
        );
        
        jComboBox1.addItem(SymmetryPanel.ACTION_COMMAND_RECOMPUTE_FROM_MESH);
        //jComboBox1.addItem(SymmetryPanel.ACTION_COMMAND_COMPUTE_FROM_FPS);
        jComboBox1.setSelectedIndex(0);
    }
    
    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }
    
    /**
     * Returns symmetry plane configuration
     * @return symmetry plane configuration
     */
    public SymmetryConfig getSymmetryConfig() {
        return this.config;
    }
    
    /**
     * Static implementation of the {@link #getIcon()} method.
     * 
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(SymmetryPanel.class.getClassLoader().getResource("/" + ICON));
    }

    /**
     * Enables/disables the selection for the computation of the symmetry from feature points.
     * @param on {@code true} = enable
     */
    public void setComputeFromFPs(boolean on) {
        if (on && jComboBox1.getItemCount() == 1) {
            jComboBox1.addItem(SymmetryPanel.ACTION_COMMAND_COMPUTE_FROM_FPS);
        }
        
        if (!on && jComboBox1.getItemCount() == 2) {
            jComboBox1.removeItemAt(1);
        }
    }
    
    /**
     * Updates GUI elements that display statistical data about the calculated Hausdorff distance.
     * 
     * @param stats Statistical data of the ordinary Hausdorff distance
     * @param first First face
     */
    public void updateHausdorffDistanceStats(DoubleSummaryStatistics stats, boolean first) {
        if (first) {
            jTextField1.setText(String.format("%.2f", stats.getAverage()));
        } else {
            jTextField2.setText(String.format("%.2f", stats.getAverage()));
        }
    }
    
    private void showSignPointsHelp() {
        JOptionPane.showMessageDialog(this,
                "Entered number represents amount of points of the mesh that are taken into account" + System.lineSeparator()
                        + "while counting the plane of approximate symmetry." + System.lineSeparator() 
                        + System.lineSeparator()
                        + "Higher number → longer calculation, possibly more accurate result." + System.lineSeparator()
                        + "Lower number → shorter calculation, possibly less accurate result.", 
                "Significant points",
                0, 
                new ImageIcon(getClass().getResource("/points.png"))
        );
                
    }
     
    private void showMinAngleCosHelp() {
        JOptionPane.showMessageDialog(this,
                "Entered number represents how large the angle between normal vector of candidate plane and the vector" + System.lineSeparator()
                        + "of two vertices can be to take into account these vertices while counting the approximate symmetry."  + System.lineSeparator()
                        + System.lineSeparator()
                        + "Higher number → fewer pairs of vertices satisfy the criterion → shorter calculation, possibly less accurate result." + System.lineSeparator()
                        + "Lower number → more pairs of vertices satisfy the criterion → longer calculation, possibly more accurate result.",
                "Minimum angle",
                0, 
                new ImageIcon(getClass().getResource("/angle.png"))
        );
    }
    
    private void showNormalAngleHelp() {                                             
        JOptionPane.showMessageDialog(this,
                "Entered number represents how large the angle between normal vector of candidate plane and vector" + System.lineSeparator()
                        + "from subtraction of normal vectors of two vertices can be to take into account these vertices while counting the approximate symmetry." + System.lineSeparator()
                         + System.lineSeparator()
                        + "Higher number → fewer pairs of vertices satisfy the criterion → shorter calculation, possibly less accurate result." + System.lineSeparator()
                        + "Lower number → more pairs of vertices satisfy the criterion → longer calculation, possibly more accurate result.",
                "Minimum normal angle",
                0, 
                new ImageIcon(getClass().getResource("/angle.png"))
        );
    }   
    
    private void showMinCurvHelp() {                                         
        JOptionPane.showMessageDialog(this,
                "Entered number represents how similar the curvature in two vertices must be" + System.lineSeparator()
                        + "to take into account these vertices while counting the plane of approximate symmetry." + System.lineSeparator()
                        + "The higher the number is the more similar they must be." + System.lineSeparator()
                        + System.lineSeparator()
                        + "Higher number → fewer pairs of vertices satisfy the criterion → shorter calculation, possibly less accurate result." + System.lineSeparator()
                        + "Lower number → more pairs of vertices satisfy the criterion → longer calculation, possibly more accurate result.",
                "Minimum curvature ratio",
                0, 
                new ImageIcon(getClass().getResource("/curvature.png"))
        );
    }                                        

    private void showRelDistHelp() {
        JOptionPane.showMessageDialog(this,
                "Entered number represents how far middle point of two vertices can be from candidate plane of symmetry" + System.lineSeparator()
                        + "to give this plane vote. Plane with highest number of votes is plane of approximate symmetry." + System.lineSeparator()
                        + System.lineSeparator()
                        + "Higher number → more pairs of vertices satisfy the criterion → longer calculation, possibly more accurate result." + System.lineSeparator()
                        + "Lower number → fewer pairs of vertices satisfy the criterion → shorter calculation, possibly less accurate result.",
                "Maximum relative distance from plane",
                0, 
                new ImageIcon(getClass().getResource("/distance.png"))
        );
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        comboSliderInteger1 = new cz.fidentis.analyst.core.ComboSliderInteger();
        comboSliderDouble4 = new cz.fidentis.analyst.core.ComboSliderDouble();
        comboSliderDouble1 = new cz.fidentis.analyst.core.ComboSliderDouble();
        comboSliderDouble2 = new cz.fidentis.analyst.core.ComboSliderDouble();
        comboSliderDouble3 = new cz.fidentis.analyst.core.ComboSliderDouble();
        jButtonInfo1 = new javax.swing.JButton();
        jButtonInfo2 = new javax.swing.JButton();
        jButtonInfo4 = new javax.swing.JButton();
        jButtonInfo3 = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jTextField1 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jComboBox1 = new javax.swing.JComboBox<>();
        jButton2 = new javax.swing.JButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jPanel1.border.title_1"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 14))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel1.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel2.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel3.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel4.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel5.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel6, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel6.text_1")); // NOI18N

        jCheckBox1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jCheckBox1, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jCheckBox1.text")); // NOI18N

        jButtonInfo1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/info.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButtonInfo1, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButtonInfo1.text")); // NOI18N
        jButtonInfo1.setBorderPainted(false);

        jButtonInfo2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/info.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButtonInfo2, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButtonInfo2.text")); // NOI18N
        jButtonInfo2.setBorderPainted(false);

        jButtonInfo4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/info.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButtonInfo4, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButtonInfo4.text")); // NOI18N
        jButtonInfo4.setBorderPainted(false);

        jButtonInfo3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/info.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButtonInfo3, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButtonInfo3.text")); // NOI18N
        jButtonInfo3.setBorderPainted(false);

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButton1.text")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jLabel5, javax.swing.GroupLayout.DEFAULT_SIZE, 143, Short.MAX_VALUE)
                            .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(18, 18, 18)
                        .addComponent(jCheckBox1))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 143, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(comboSliderDouble1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(comboSliderInteger1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addComponent(comboSliderDouble2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addComponent(comboSliderDouble3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jButtonInfo1)
                                    .addComponent(jButtonInfo2)
                                    .addComponent(jButtonInfo4)
                                    .addComponent(jButtonInfo3)))
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addComponent(jButton1)
                                    .addGap(81, 81, 81))
                                .addComponent(comboSliderDouble4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jLabel1))
                    .addComponent(comboSliderInteger1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jButtonInfo1)))
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(26, 26, 26)
                        .addComponent(jLabel2))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(comboSliderDouble1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(17, 17, 17)
                        .addComponent(jButtonInfo2)))
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(26, 26, 26)
                        .addComponent(jLabel3))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(comboSliderDouble2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(16, 16, 16)
                        .addComponent(jButtonInfo3)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jLabel4)
                        .addGap(47, 47, 47)
                        .addComponent(jLabel5))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(comboSliderDouble3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(comboSliderDouble4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(jButtonInfo4)))
                .addGap(24, 24, 24)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel6)
                    .addComponent(jCheckBox1)
                    .addComponent(jButton1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jPanel2.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12))); // NOI18N

        jTextField1.setText(org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jTextField1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel7, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel7.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel8, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jLabel8.text")); // NOI18N

        jTextField2.setText(org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jTextField2.text")); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel8)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(21, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7)
                    .addComponent(jLabel8)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.openide.awt.Mnemonics.setLocalizedText(jButton2, org.openide.util.NbBundle.getMessage(SymmetryPanel.class, "SymmetryPanel.jButton2.text")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jButton2)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(82, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private cz.fidentis.analyst.core.ComboSliderDouble comboSliderDouble1;
    private cz.fidentis.analyst.core.ComboSliderDouble comboSliderDouble2;
    private cz.fidentis.analyst.core.ComboSliderDouble comboSliderDouble3;
    private cz.fidentis.analyst.core.ComboSliderDouble comboSliderDouble4;
    private cz.fidentis.analyst.core.ComboSliderInteger comboSliderInteger1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonInfo1;
    private javax.swing.JButton jButtonInfo2;
    private javax.swing.JButton jButtonInfo3;
    private javax.swing.JButton jButtonInfo4;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox<String> jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    // End of variables declaration//GEN-END:variables
}
