package cz.fidentis.analyst.core;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.canvas.toolbar.SceneToolboxSingleFace;
import cz.fidentis.analyst.curvature.CurvatureAction;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.symmetry.ProfilesAction;
import cz.fidentis.analyst.symmetry.SymmetryAction;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.windows.TopComponent;

/**
 * The non-singleton window/tab for detail inspection of a single face.
 *
 * @author Radek Oslejsek
 */
public final class SingleFaceTab extends TopComponent {
    
    private final Canvas canvas;
    private final TopControlPanel controlPanel;
    private final JScrollPane scrollPane;
    
    /**
     * Constructor.
     * @param face Face
     * @param name Tab name
     */
    public SingleFaceTab(HumanFace face, String name) {
        canvas = new Canvas();
        canvas.addPrimaryFace(face);
        canvas.getScene().setDefaultColors();
        canvas.addToolBox(new SceneToolboxSingleFace(canvas));
        controlPanel = new TopControlPanel();
        
        scrollPane = new JScrollPane(controlPanel);
        
        setName(name);
        initComponents();
        
        // change the height so that it corresponds to the height of the OpenGL window
        canvas.addComponentListener(new ComponentAdapter() {
            @Override
            public void componentResized(ComponentEvent e) {
                scrollPane.setSize(ControlPanel.CONTROL_PANEL_WIDTH, canvas.getHeight());
            }
        });

        /*
         * Add and open controll panels: 
         */
        // (Re)render scene after all change listeners have been called
        // (the first added listener is called last)
        controlPanel.addChangeListener(e -> getCanvas().renderScene());
        new CurvatureAction(getCanvas(), controlPanel);
        new SymmetryAction(getCanvas(), controlPanel);
        new ProfilesAction(getCanvas(), controlPanel);
    }
    
    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER; // TO DO: change to .PERSISTENCE_ONLY_OPENED when we can re-create the ProjectTC
    }
    
    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(canvas, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
//                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addComponent(
                                        scrollPane,
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH
                                )
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(canvas)
//                                        .addComponent(renderingToolBar)
                                        .addComponent(scrollPane)
                                ))
        );
    }

    public Canvas getCanvas() {
        return canvas;
    }
}
