
package cz.fidentis.analyst.face.events;

import cz.fidentis.analyst.face.HumanFace;

/**
 * An event fired when a new KdTree is calculated

 * @author Matej Kovar
 */
public class KdTreeCreated extends KdTreeEvent {
    
    /**
     * Constructor.
     * @param face Human face related to the event
     * @param name Event name provided by issuer
     * @param issuer The issuer
     */
    public KdTreeCreated(HumanFace face, String name, Object issuer) {
        super(face, name, issuer);
    }

    @Override
    public boolean isCalculated() {
        return true;
    }

    
}
