package cz.fidentis.analyst.visitors;

/**
 * Classes implementing this interface are able to compute minimal distance of 
 * the given 3D point to mesh facets.
 * 
 * @author Radek Oslejsek
 */
public interface Distance {

    /**
     * Returns the minimal found distance.
     * 
     * @return the minimal found distance, 
     * {@code Double.POSITIVE_INFINITY} if no distance has been computed so far
     */
    double getDistance();
    
}
