/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author Richard Pajerský
 * 
 * Wireframe button in toolbar and Edit
 */
@ActionID(
        category = "Edit",
        id = "cz.fidentis.analyst.gui.Wireframe"
)
@ActionRegistration(
        iconBase = "wireframe16x16.png",
        displayName = "#CTL_Wireframe"
)
@ActionReferences({
    @ActionReference(path = "Menu/Edit", position = 2600, separatorBefore = 2550),
    @ActionReference(path = "Toolbars/File", position = 300)
})
@Messages("CTL_Wireframe=Wireframe")
public final class Wireframe implements ActionListener {

    /**
     * Flag for whether model should be displayed as wire-frame 
     */
    boolean wiredModelClicked = false;
    
    @Override
    public void actionPerformed(ActionEvent e) {
        if (wiredModelClicked) {
            //resetLabelBackround(wiredModelButton);
            wiredModelClicked = false;
            Canvas.setDrawWired(wiredModelClicked);
            /*canvasSymmetryPanel.setDrawWired(wiredModelClicked);
            canvasModelView.setDrawWired(wiredModelClicked);*/
        } else {
            //setLabelBackround(wiredModelButton);
            wiredModelClicked = true;
            Canvas.setDrawWired(wiredModelClicked);
            /*canvasSymmetryPanel.setDrawWired(wiredModelClicked);
            canvasModelView.setDrawWired(wiredModelClicked);*/
        }
    }

    /**
     * Changes backround of labels to darker green color
     * @param jl label of which backround changes 
     */
    private void setLabelBackround(JLabel jl) {
        jl.setBackground(new Color(11,56,49));
    }

    /**
     * Changes backround of the label back to original
     * @param jl label of which backround is return to original
     */
    private void resetLabelBackround(JLabel jl) {
        jl.setBackground(new Color(20,114,105));
    }
}
