/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author Richard Pajerský
 * 
 * Window with basic Preferences
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//Preferences//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "PreferencesTopComponent",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "properties", openAtStartup = false)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.PreferencesTopComponent")
@ActionReference(path = "Menu/Tools", position = 2600, separatorBefore = 2550 /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_PreferencesAction",
        preferredID = "PreferencesTopComponent"
)
@Messages({
    "CTL_PreferencesAction=Preferences",
    "CTL_PreferencesTopComponent=Preferences Window",
    "HINT_PreferencesTopComponent=This is a Preferences window"
})
public final class PreferencesTopComponent extends TopComponent {

    public PreferencesTopComponent() {
        initComponents();
        setName(Bundle.CTL_PreferencesTopComponent());
        setToolTipText(Bundle.HINT_PreferencesTopComponent());
        putClientProperty(TopComponent.PROP_KEEP_PREFERRED_SIZE_WHEN_SLIDED_IN, Boolean.TRUE);
        
        createPreferencesFile();
    }
    
    private void createPreferencesFile() {
        //testing preferences fodler        
        //String propPath = System.getProperty("user.home") + "/preferences";
        try {
            File myObj = new File(/*propPath + */"preferences.fip");
        if (myObj.createNewFile()) {
            //JOptionPane.showConfirmDialog(null, "File created: " + myObj.getName());
        } else {
            //JOptionPane.showConfirmDialog(null, "File already exists." + myObj.getName());
        }
        } catch (IOException e) {
        JOptionPane.showConfirmDialog(null, "An error occurred.");
        e.printStackTrace();
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton1 = new javax.swing.JButton();
        jFormattedTextField1 = new javax.swing.JFormattedTextField();
        jLabel1 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jSlider2 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jFormattedTextField1.setText(org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jFormattedTextField1.text")); // NOI18N
        jFormattedTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jFormattedTextField1ActionPerformed(evt);
            }
        });

        jLabel1.setLabelFor(jFormattedTextField1);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jLabel1.text")); // NOI18N

        jSlider1.setMajorTickSpacing(3);
        jSlider1.setMaximum(7);
        jSlider1.setMinimum(1);
        jSlider1.setMinorTickSpacing(3);
        jSlider1.setPaintTicks(true);
        jSlider1.setToolTipText(org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jSlider1.toolTipText")); // NOI18N
        jSlider1.setValue(4);
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });

        jSlider2.setMajorTickSpacing(3);
        jSlider2.setMaximum(7);
        jSlider2.setMinimum(1);
        jSlider2.setMinorTickSpacing(3);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(true);
        jSlider2.setToolTipText(org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jSlider2.toolTipText")); // NOI18N
        jSlider2.setValue(4);
        jSlider2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider2StateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(PreferencesTopComponent.class, "PreferencesTopComponent.jLabel3.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jFormattedTextField1)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addGap(0, 183, Short.MAX_VALUE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jFormattedTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addContainerGap(172, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        JFileChooser chooser = new JFileChooser(getPrefferedModelPath());
        chooser.setDialogTitle("Model directory");
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            //JOptionPane.showConfirmDialog(null,
            //    chooser.getCurrentDirectory(), "", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
            //JOptionPane.showConfirmDialog(null,
            //    chooser.getSelectedFile(), "", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
            setPrefferedModelPath(chooser.getSelectedFile().toString());
        }
        else {
            System.out.println("No Selection ");
        }
        
        componentOpened();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jFormattedTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jFormattedTextField1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jFormattedTextField1ActionPerformed

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        double newSpeed = jSlider1.getValue() / 10.0;
        Manipulator3D.setRotationSpeed(newSpeed);
    }//GEN-LAST:event_jSlider1StateChanged

    private void jSlider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider2StateChanged
        double newSpeed = jSlider2.getValue() / 10.0;
        Manipulator3D.setMoveSpeed(newSpeed);
    }//GEN-LAST:event_jSlider2StateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JFormattedTextField jFormattedTextField1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    // End of variables declaration//GEN-END:variables
    
    private void setPrefferedModelPath(String s) {
        try {
            FileWriter rewriter = new FileWriter("preferences.fip", false);
            rewriter.write(s);
            rewriter.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }   
    }
    
    private String getPrefferedModelPath() {
        String data = "";
        try {
            File myObj = new File(/*propPath + */"preferences.fip");
            if (myObj.length() == 0)
                return data;
            try (Scanner myReader = new Scanner(myObj)) {
                data = myReader.nextLine();
            }            
        } catch (FileNotFoundException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        return data;
    }
    
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
        jFormattedTextField1.setText(getPrefferedModelPath());
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
