package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.mesh.io.ModelFileFilter;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.IOException;

/**
 * @author Daniel Sokol
 * <p>
 * Temporary interface to test rendering heatmap.
 */


public class TestInterface {
    private static final JFrame testFrame = new JFrame();
    private static HumanFace comparedModel;

    public static void main(String[] args) {

        JButton addButton = new JButton("Load face to compare");
        JButton compareButton = new JButton("Show differences");

        Canvas testCanvas = new Canvas();
        ComparisonGLEventListener colorListener = new ComparisonGLEventListener(testCanvas);
        testCanvas.setListener(colorListener);
        JColorChooser colorChooserMin = new JColorChooser(Color.BLUE);
        JColorChooser colorChooserMax = new JColorChooser(Color.RED);

        JButton color1 = new JButton("Pick color for smallest distances");
        JFrame colorMinFrame = new JFrame();
        colorMinFrame.add(colorChooserMin);
        colorMinFrame.pack();

        JButton color2 = new JButton("Pick color for largest distances");
        JFrame colorMaxFrame = new JFrame();
        colorMaxFrame.add(colorChooserMax);
        colorMaxFrame.pack();

        addButton.addActionListener(e -> {
                    try {
                        JFileChooser jFileChooser1 = new JFileChooser();
                        jFileChooser1.setPreferredSize(new Dimension(800, 500));
                        jFileChooser1.addChoosableFileFilter(new ModelFileFilter(new String[]{"obj", "OBJ"}, "*.obj"));
                        jFileChooser1.showOpenDialog(testFrame);
                        if (jFileChooser1.getSelectedFile() == null) {
                            System.out.print("No file chosen.");
                        } else {
                            comparedModel = new HumanFace(new File(jFileChooser1.getSelectedFile().getPath()));
                            colorListener.setComparedFace(comparedModel);
                            addButton.setBackground(new Color(50, 200, 20));

                        }
                    } catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
        );

        compareButton.addActionListener(e -> colorListener.compare(colorChooserMin.getColor(), colorChooserMax.getColor()));

        color1.addActionListener(e -> colorMinFrame.setVisible(true));

        color2.addActionListener(e -> colorMaxFrame.setVisible(true));

        testFrame.setLayout(new GridBagLayout());
        testFrame.setVisible(true);
        testFrame.setSize(1200, 700);

        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1;
        c.weightx = 1;

        c.gridheight = 6;
        c.gridwidth = 4;
        c.weightx = 4;
        testFrame.add(testCanvas, c);
        c.gridheight = 1;
        c.gridwidth = 2;
        c.gridx = 4;
        c.weightx = 2;
        testFrame.add(addButton, c);
        c.gridy = 1;
        testFrame.add(compareButton, c);
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1;
        testFrame.add(color1, c);
        c.gridx = 5;
        testFrame.add(color2, c);

    }
}

