package cz.fidentis.analyst.gui.scene;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.util.List;

/**
 * A drawable triangular mesh, i.e., a mesh model with drawing information like 
 * material, transparency, color, relative transformations in the scene etc. 
 * This class encapsulates rendering state and parameters,
 * 
 * @author Radek Oslejsek
 */
public class DrawableMesh {
    
    private final MeshModel model;
    
    private boolean display = true;
    
    // TO DO - R. Pajersky: add transformation attributes and methods
    
    /**
     * Constructor. 
     * 
     * @param model Drawable mesh model
     * @throws IllegalArgumentException if the model is {@code null}
     */
    public DrawableMesh(MeshModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
    }
    
    /**
     * Returns list of individual facets.
     * 
     * @return list of individual facets.
     */
    public List<MeshFacet> getFacets() {
        return model.getFacets();
    }
    
    /**
     * This drawable mesh is included in the rendered scene.
     */
    public void show() {
        display = true;
    }
    
    /**
     * This drawable mesh is excluded from the rendered scene (skipped).
     */
    public void hide() {
        display = false;
    }
    
    /**
     * 
     * @return {@code true} if the object is included (rendered) in the scene.
     */
    public boolean isShown() {
        return display;
    }
}
