package cz.fidentis.analyst.curvature;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.core.ControlPanelBuilder;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;

/**
 * Control panel for curvature analysis.
 * 
 * @author Radek Oslejsek
 */
public class CurvaturePanel extends ControlPanel {
    
    /*
     * Mandatory design elements
     */
    public static final String ICON = "curvature28x28.png";
    public static final String NAME = "Curvature";
    
    /*
     * External actions
     */
    public static final String ACTION_COMMAND_SHOW_HIDE_HEATMAP = "show-hide heatmap";
    public static final String ACTION_COMMAND_SET_CURVATURE_TYPE = "set curvature type";
    
    /*
     * Configuration of panel-specific GUI elements
     */
    public static final String GAUSSIAN_CURVATURE = "Gaussian";
    public static final String MEAN_CURVATURE = "Mean";
    public static final String MIN_CURVATURE = "Min";
    public static final String MAX_CURVATURE = "Max";
    
    /**
     * Constructor.
     * @param action Action listener
     */
    public CurvaturePanel(ActionListener action) {
        this.setName(NAME);
        
        ControlPanelBuilder builder = new ControlPanelBuilder(this);
        
        builder.addCaptionLine("Visualization options:");
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "Show curvature", 
                false,
                createListener(action, ACTION_COMMAND_SHOW_HIDE_HEATMAP));
        builder.addComboBox(
                List.of(GAUSSIAN_CURVATURE, MEAN_CURVATURE, MIN_CURVATURE, MAX_CURVATURE), 
                createListener(action, ACTION_COMMAND_SET_CURVATURE_TYPE)
        );
        builder.addGap();
        builder.addLine();
        builder.addCaptionLine("TO DO: Interactive histogram");
        builder.addLine();
        builder.addVerticalStrut();
    }

    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }
    
    /**
     * Static implementation of the {@link #getIcon()} method.
     * 
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(CurvaturePanel.class.getClassLoader().getResource("/" + ICON));
    }
}
