/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.symmetry;

import cz.fidentis.analyst.core.ControlPanel;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

/**
 * Control panel for face profiles.
 * 
 * @author Dominik Racek
 * @author Radek Oslejsek
 */
public class ProfilesPanel extends ControlPanel {
    
     /*
     * Handled actions
     */
    public static final String ACTION_COMMAND_EXPORT = "export";
    public static final String ACTION_SHIFT_CUTTING_PLANE = "shift plane";
    public static final String ACTION_MIRROR_CUTS = "mirror-cuts";
    public static final String ACTION_CHANGE_CUTTING_PLANE = "change cutting plane";
    
    public static final String OPTION_VERTICAL_PLANE = "Vertical cutting plane";
    public static final String OPTION_SYMMETRY_PLANE = "From symmetry plane";
    
    /*
     * Mandatory design elements
     */
    public static final String ICON = "profiles28x28.png";
    public static final String NAME = "Profiles";
    
    private final ActionListener action;
    
    /**
     * Constructor for one face.
     * 
     * @param action Action listener
     * @param curve Cross section curve
     */
    public ProfilesPanel(ActionListener action, CrossSectionCurve curve) {
        this(action, curve, null);
    }
    
    /**
     * Constructor for two faces
     * 
     * @param action Action listener
     * @param primaryCurve Primary cross section curve
     * @param secondaryCurve Secondary cross section curve
     */
    public ProfilesPanel(ActionListener action, CrossSectionCurve primaryCurve, CrossSectionCurve secondaryCurve) {
        setName(NAME);
        initComponents();
        
        this.action = action;
        
        polylinePanel1.setPrimarySegments(primaryCurve);
        polylinePanel1.setSecondarySegments(secondaryCurve);
        
        this.resetSlider();
        
        jCheckBox1.addActionListener(createListener(action, ACTION_MIRROR_CUTS));
        jButton1.addActionListener(createListener(action, ACTION_COMMAND_EXPORT));
        
        jComboBox1.addItem(OPTION_VERTICAL_PLANE);
        jComboBox1.addItem(OPTION_SYMMETRY_PLANE);
        jComboBox1.setSelectedIndex(0);
        jComboBox1.addActionListener(createListener(action, ACTION_CHANGE_CUTTING_PLANE));
        
        // restrict the slider range into the half if mirror cuts are turned on
        /*
        jCheckBox1.addActionListener((ActionEvent e) -> {
            double val = comboSliderDouble1.getValue();
            if (((JCheckBox) e.getSource()).isSelected()) {
                comboSliderDouble1.setRange(0.5, 1, 2);
                comboSliderDouble1.setValue((val < 0.5) ? 1.0 - val : val);
            } else {
                comboSliderDouble1.setRange(0, 1, 2);
                comboSliderDouble1.setValue(val);
            }
        });
        */
    }
    
    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }

    /**
     * Static implementation of the {@link #getIcon()} method.
     *
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(ProfilesPanel.class.getClassLoader().getResource("/" + ICON));
    }
    
    /**
     * Returns embedded {@link CurveRenderingPanel}
     * @return embedded {@link CurveRenderingPanel}
     */
    public CurveRenderingPanel getProfileRenderingPanel() {
        return this.polylinePanel1;
    }
    
    /**
     * Returns {@code true} if the mirror cutting plane is turned on. 
     * @return {@code true} if the mirror cutting plane is turned on. 
     */
    public boolean isMirrorCutsChecked() {
        return jCheckBox1.isSelected();
    }
    
    /**
     * Resets the slider into initial values
     */
    public void resetSlider() {
        spinSlider1.initDouble(0.5, 0.0, 1.0, 2);
        spinSlider1.addSpinnerListener(createListener(this.action, ACTION_SHIFT_CUTTING_PLANE));
    }
    
    /**
     * Sets the combo box into the default value.
     */
    public void setDefaultPlaneSelection() {
        jComboBox1.setSelectedIndex(0);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jButton1 = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox<>();
        spinSlider1 = new cz.fidentis.analyst.core.SpinSlider();
        polylinePanel1 = new cz.fidentis.analyst.symmetry.CurveRenderingPanel();

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBox1, org.openide.util.NbBundle.getMessage(ProfilesPanel.class, "ProfilesPanel.jCheckBox1.text")); // NOI18N
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(ProfilesPanel.class, "ProfilesPanel.jButton1.text")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jCheckBox1)
                        .addGap(18, 18, 18)
                        .addComponent(jButton1))
                    .addComponent(spinSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(174, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(spinSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBox1)
                    .addComponent(jButton1))
                .addContainerGap(25, Short.MAX_VALUE))
        );

        polylinePanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout polylinePanel1Layout = new javax.swing.GroupLayout(polylinePanel1);
        polylinePanel1.setLayout(polylinePanel1Layout);
        polylinePanel1Layout.setHorizontalGroup(
            polylinePanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        polylinePanel1Layout.setVerticalGroup(
            polylinePanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 398, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(polylinePanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(polylinePanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jCheckBox1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox<String> jComboBox1;
    private javax.swing.JPanel jPanel1;
    private cz.fidentis.analyst.symmetry.CurveRenderingPanel polylinePanel1;
    private cz.fidentis.analyst.core.SpinSlider spinSlider1;
    // End of variables declaration//GEN-END:variables
}
