package cz.fidentis.analyst.scene;

import com.jogamp.opengl.GL2;
import javax.vecmath.Point3d;

/**
 * A line to be shown in the scene, e.g., to show a ray.
 * 
 * @author Radek Oslejsek
 */
public class DrawableLine extends Drawable {
    
    private final Point3d startPoint;
    private final Point3d endPoint;
    
    /**
     * Constructor.
     * 
     * @param start Start point
     * @param end  End point
     */
    public DrawableLine(Point3d start, Point3d end) {
        this.startPoint = start;
        this.endPoint = end;
    }

    @Override
    protected void renderObject(GL2 gl) {
        gl.glBegin(GL2.GL_LINES);
        gl.glVertex3d(startPoint.x, startPoint.y, startPoint.z);
        gl.glVertex3d(endPoint.x, endPoint.y, endPoint.z);
        gl.glEnd();
    }
    
    
}
