package cz.fidentis.analyst.core;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;

/**
 * ComboSlider implements a combination of horizontal slider and input text field.
 * The slider and input field are synchronized automatically.
 * 
 * @author Radek Oslejsek
 */
public abstract class ComboSlider extends JPanel {
 
    private final JSlider slider = new JSlider();
    private final JFormattedTextField inputField = new JFormattedTextField();
    
    public static final int DEFAULT_TEXT_FIELD_WIDTH = 70;
    public static final int DEFAULT_TEXT_FIELD_HEIGHT = 40;
    
    /**
     * Constructor.
     */
    public ComboSlider() {
        initComponents();
    }

    /**
     * Adds the specified action listener to receive action events from this GUI item.
     *
     * @param listener the action listener to be added
     */
    public synchronized void addActionListener(ActionListener listener) {
        inputField.addActionListener(listener);
    }
    
    /**
     * The slider is on the left, followed by ti input field, by default.
     * This method switches the order.
     */
    public void setSliderEast() {
        remove(slider);
        add(slider);
    }
    
    protected JSlider getSlider() {
        return slider;
    }
    
    protected JFormattedTextField getInputField() {
        return inputField;
    }
    
    protected final void initComponents() {
        add(slider);
        add(inputField);
        inputField.setPreferredSize(new Dimension(DEFAULT_TEXT_FIELD_WIDTH, DEFAULT_TEXT_FIELD_HEIGHT));
    }
}
