package cz.fidentis.analyst.gui.canvas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;

/**
 * Listener invoked when the OpenGL canvas initiated, shown, or resized.
 * 
 * @author Radek Oslejsek
 */
public class CanvasListener implements GLEventListener {
    
    private Canvas canvas;
    
    /**
     * Constructor.
     * 
     * @param canvas Canvas
     * @throws IllegalArgumentException if the canvas is {@code null}
     */
    public CanvasListener(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this.canvas = canvas;
    }
    
    @Override
    public void init(GLAutoDrawable glad) {
        //System.out.println("CanvasListener.init");
        canvas.getSceneRenderer().initSceneGLContext(glad.getGL().getGL2());
    }

    @Override
    public void dispose(GLAutoDrawable glad) {
        //System.out.println("CanvasListener.dispose");
    }

    @Override
    public void display(GLAutoDrawable glad) {
        //System.out.println("CanvasListener.display " + this.toString());
        canvas.getSceneRenderer().renderScene(canvas.getCamera());
    }

    @Override
    public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {
        //System.out.println("CanvasListener.reshape");
        canvas.getSceneRenderer().setViewport(x, y, width, height);
    }
    
}
