package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

public class CornerTable {

    private List<Integer> vertexIndexes = new ArrayList<>();
    private List<Integer> oppositeVertexIndexes = new ArrayList<>();

    public int getTriangleStartingVertexIndex(int c) {
        return c / 3;
    }

    public int getIndexOfOppositeVertex(int c) {
        return oppositeVertexIndexes.get(c);
    } // opposite

    public int getIndexOfNextVertexInTriangle(int c) {
        if ((c % 3) == 2)
            return c - 1;
        return c + 1;
    }// next in t(c)

    public int getIndexOfPreviousVertexInTriangle(int c) {
        return getIndexOfNextVertexInTriangle(getIndexOfNextVertexInTriangle(c));
    } // previous corner

    public int getIndexOfTipVertexOnLeft(int c) {
        return getIndexOfOppositeVertex(getIndexOfPreviousVertexInTriangle(c));
    }  // tip on left

    public int getIndexOfTipVertexOnRight(int c) {
        return getIndexOfOppositeVertex(getIndexOfNextVertexInTriangle(c));
    } // tip on right

    public int s(int c) {
        return getIndexOfNextVertexInTriangle(getIndexOfTipVertexOnLeft(c));
    } // next around v(c)
}
