package cz.fidentis.analyst.symmetry;

/**
 *
 * @author Natália Bebjaková
 * 
 * Helping representation of triangle in symmetry estimate 
 */

public class Triangle { 
    protected int vertex1;
    protected int vertex2;
    protected int vertex3;
    
    /**
     * Creates new triangle
     * 
     * @param v1 first vertex 
     * @param v2 second vertex
     * @param v3 third vertex
     */        
    public Triangle(int v1, int v2, int v3) {
        this.vertex1 = v1;
        this.vertex2 = v2; 
        this.vertex3 = v3;
    }
    /**
     * 
     * @return first vertex of triangle
     */
    public int getVertex1() {
        return vertex1;
    }

    /**
     * 
     * @param vertex1 new vertex
     */
    public void setVertex1(int vertex1) {
        this.vertex1 = vertex1;
    }

    /**
     * 
     * @return second vertex of triangle
     */
    public int getVertex2() {
        return vertex2;
    }

    /**
     * 
     * @param vertex2 new vertex 
     */
    public void setVertex2(int vertex2) {
        this.vertex2 = vertex2;
    }

    /**
     * 
     * @return third vertex of triangle
     */
    public int getVertex3() {
        return vertex3;
    }

    /**
     * 
     * @param vertex3 new vertex 
     */
    public void setVertex3(int vertex3) {
        this.vertex3 = vertex3;
    }

    /**
     * Triangles are same if they have same vertices
     * 
     * @param obj other triangle 
     * @return true if two triangles are same 
     */        
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Triangle) {
            Triangle t = (Triangle)obj;
            if (((this.vertex1 == t.vertex1) || (this.vertex1 == t.vertex2) || (this.vertex1 == t.vertex3)) &&
                ((this.vertex2 == t.vertex1) || (this.vertex2 == t.vertex2) || (this.vertex2 == t.vertex3)) &&
                ((this.vertex3 == t.vertex1) || (this.vertex3 == t.vertex2) || (this.vertex3 == t.vertex3)))
                return (true);
        }
        return (false);
    }
       
    /**
     * 
     * @return hascode of the triangle
     */
    @Override 
    public int hashCode() {
        return (this.vertex1 * 100 ^ this.vertex2 * 100 ^ this.vertex3);
    }
}
