package cz.fidentis.analyst.symmetry;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshPoint;

/**
 *
 * @author Natália Bebjaková
 * 
 * Representation of the plane 
 */
public class Plane {
    public double a;
    public double b;
    public double c;
    public double d;
    private static MeshFacet facet;

    /**
     * Creates new plane 
     * 
     * @param a a coordinate 
     * @param b b coordinate
     * @param c c coordinate
     * @param d d coordinate
     */
    public Plane(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }
    
    /**
     * Normalize the plane
     */
    public void normalize() {
        double normalLength = Math.sqrt(a * a + b * b + c * c);
        
        a /= normalLength;
        b /= normalLength;
        c /= normalLength;
        d /= normalLength;
    }
    
    /**
     * Returns plane that is represented by mesh which can be merged with model  
     * 
     * @param centroid middle point of the plane 
     * @param a a coordinate
     * @param b b coordinate
     * @param scale distance of points given by bounding box
     * @return plane represented as mesh 
     */
    public static SymmetryCounter createPlaneMesh(MeshPoint centroid, MeshPoint a, MeshPoint b, double scale) {
        facet = new MeshFacet();
        SymmetryCounter planeMesh = new SymmetryCounter(facet);
        
        MeshPoint[] points = new MeshPoint[4];
        
        points[0] = centroid.subtractPosition(a.multiplyPosition(scale)).subtractPosition(b.multiplyPosition(scale));
        points[1] = centroid.subtractPosition(a.multiplyPosition(scale)).addPosition(b.multiplyPosition(scale));
        points[2] = centroid.addPosition(a.multiplyPosition(scale)).addPosition(b.multiplyPosition(scale));
        points[3] = centroid.addPosition(a.multiplyPosition(scale)).subtractPosition(b.multiplyPosition(scale));
        
        for (MeshPoint point : points) {
            facet.addVertex(point);
        }

        Triangle[] triangles = new Triangle[4];
        
        triangles[0] = new Triangle(0, 1, 2);
        triangles[1] = new Triangle(0, 2, 3);
        triangles[2] = new Triangle(0, 2, 1);
        triangles[3] = new Triangle(0, 3, 2);
        planeMesh.setTriangles(triangles);
        
        MeshPoint[] normals = planeMesh.CalculateNormals();
        
        facet.getVertices().clear();
        
        for (int i = 0; i < points.length; i++) {
            facet.addVertex(new MeshPoint(points[i].getPosition(),normals[i].getPosition(),null));
        }
        return planeMesh;
    }
 
}
