package cz.fidentis.analyst.symmetry;

/**
 *
 * @author Natália Bebjaková
 * 
 * Respresents plane with added atribute - votes, that play role
 * in decision about symmetry estimate of the 3D model
 */
public class AproxSymmetryPlane extends Plane implements Comparable<AproxSymmetryPlane> {
    public Integer votes;

    /**
     * returns number of votes that were given to plane while computing the symmetry 
     * 
     * @return Number of votes 
     */
    public Integer getVotes() {
        return votes;
    }

    /**
     * 
     * @param plane Original plane without votes 
     * @param votes number of votes given to the plane
     */
    public AproxSymmetryPlane(Plane plane, int votes) {
        super(plane.a, plane.b, plane.c, plane.d);
        this.votes = votes;
    }
    
    /**
     * Enables to compare two approximate planes due to number of votes 
     * 
     * @param other plane to be compared 
     * @return number that decides which plane has more votes 
     */
    @Override
    public int compareTo(AproxSymmetryPlane other) {
        return this.votes.compareTo(other.votes);
    }
}
