package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.mesh.io.MeshModelExporter;
import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/**
 *
 * @author Natalia Bebjakova
 * 
 * Main window of the applicaion
 */

public class UserInterface extends javax.swing.JFrame {
    /**
     * Flag for backround color of the new project button
     */
    boolean pressedNewProject = false;
    /**
     * Flag for whether model should be displayed as wire-frame 
     */
    boolean wiredModelClicked = false;
    /**
     * Panel that is actualy displayed on the window
     */
    private JPanel actualPanel;
    /**
     * Main frame of the application
     */
    public static JFrame frameMain; 
    /**
     * x coordinate of the mouse 
     */
    int xMouse;
    /**
     * y coordinate of the mouse
     */
    int yMouse;
    
    /**
    * Creates new form Interface
     */
    public UserInterface() {
        initComponents();
        topPanel.setVisible(false);
        actualPanel = startingPanel;
        symmetryPanel1.setCanvas(canva1);
    }

    /**
     * 
     * @return JPanel for estimating symmetry of the model
     */
    public SymmetryPanel getSymmetryPanel1() {
        return symmetryPanel1;
    }
    
    /**
     * Enables to switch between panels
     * @param panel New panel that will be visible
     */
    private void switchPanelOnMainPanel(JPanel panel) {
        actualPanel = panel;
        jPanel2.removeAll();
        jPanel2.repaint();
        jPanel2.revalidate();
        jPanel2.add(panel);
        jPanel2.repaint();
        jPanel2.revalidate();
        panel.add(jPanel1);
        jPanel1.setVisible(true);
    }
    
    /**
     * Changes backround of labels to darker green color
     * @param jl label of which backround changes 
     */
    public void setLabelBackround(JLabel jl) {
        jl.setBackground(new Color(11,56,49));
    }
    
    /**
     * Changes backround of the label back to original
     * @param jl label of which backround is return to original
     */
    public void resetLabelBackround(JLabel jl) {
        jl.setBackground(new Color(20,114,105));
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     * 
     * Code generated by NetBeans
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topPanel = new javax.swing.JPanel();
        compareTwo = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        compareDB = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        batchProcessing = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        symetryEstimator = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        newProject = new javax.swing.JLabel();
        close = new javax.swing.JLabel();
        wiredModelButton = new javax.swing.JLabel();
        homeButton = new javax.swing.JLabel();
        minimize = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        startingPanel = new javax.swing.JPanel();
        javax.swing.JLabel logo = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        compareTwoMain = new javax.swing.JPanel();
        JLabel8 = new javax.swing.JLabel();
        compareTwoMain1 = new javax.swing.JPanel();
        JLabel9 = new javax.swing.JLabel();
        batchMain = new javax.swing.JPanel();
        JLabel10 = new javax.swing.JLabel();
        symetryMain = new javax.swing.JPanel();
        JLabel11 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        viewerButton = new javax.swing.JLabel();
        symetryPanel = new javax.swing.JPanel();
        viewerPanel = new javax.swing.JPanel();
        canva1 = new cz.fidentis.analyst.gui.Canvas();
        reloadModelButton = new javax.swing.JLabel();
        exportModelButton = new javax.swing.JLabel();
        symmetryPanel1 = new cz.fidentis.analyst.gui.SymmetryPanel();
        modelViewPanel = new javax.swing.JPanel();
        reloadModelButton1 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        canva2 = new cz.fidentis.analyst.gui.Canvas();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setAlwaysOnTop(true);
        setAutoRequestFocus(false);
        setBackground(new java.awt.Color(20, 114, 105));
        setLocationByPlatform(true);

        topPanel.setBackground(new java.awt.Color(20, 114, 105));

        compareTwo.setBackground(new java.awt.Color(20, 114, 105));
        compareTwo.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/compareTwoStart.png"))); // NOI18N
        jLabel1.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        javax.swing.GroupLayout compareTwoLayout = new javax.swing.GroupLayout(compareTwo);
        compareTwo.setLayout(compareTwoLayout);
        compareTwoLayout.setHorizontalGroup(
            compareTwoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(compareTwoLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE)
                .addContainerGap())
        );
        compareTwoLayout.setVerticalGroup(
            compareTwoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(compareTwoLayout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 152, Short.MAX_VALUE)
                .addContainerGap())
        );

        compareDB.setBackground(new java.awt.Color(20, 114, 105));
        compareDB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/copareWithDatabaseStart.png"))); // NOI18N
        jLabel2.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        javax.swing.GroupLayout compareDBLayout = new javax.swing.GroupLayout(compareDB);
        compareDB.setLayout(compareDBLayout);
        compareDBLayout.setHorizontalGroup(
            compareDBLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 192, Short.MAX_VALUE)
        );
        compareDBLayout.setVerticalGroup(
            compareDBLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(compareDBLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        batchProcessing.setBackground(new java.awt.Color(20, 114, 105));
        batchProcessing.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/batchProcessingStart.png"))); // NOI18N
        jLabel3.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        javax.swing.GroupLayout batchProcessingLayout = new javax.swing.GroupLayout(batchProcessing);
        batchProcessing.setLayout(batchProcessingLayout);
        batchProcessingLayout.setHorizontalGroup(
            batchProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(batchProcessingLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        batchProcessingLayout.setVerticalGroup(
            batchProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(batchProcessingLayout.createSequentialGroup()
                .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        symetryEstimator.setBackground(new java.awt.Color(20, 114, 105));
        symetryEstimator.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        symetryEstimator.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                symetryEstimatorMouseClicked(evt);
            }
        });

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStartP.png"))); // NOI18N
        jLabel4.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jLabel4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                jLabel4MouseMoved1(evt);
            }
        });
        jLabel4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel4MouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jLabel4MouseExited(evt);
            }
        });

        javax.swing.GroupLayout symetryEstimatorLayout = new javax.swing.GroupLayout(symetryEstimator);
        symetryEstimator.setLayout(symetryEstimatorLayout);
        symetryEstimatorLayout.setHorizontalGroup(
            symetryEstimatorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(symetryEstimatorLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        symetryEstimatorLayout.setVerticalGroup(
            symetryEstimatorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryEstimatorLayout.createSequentialGroup()
                .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout topPanelLayout = new javax.swing.GroupLayout(topPanel);
        topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(
            topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(topPanelLayout.createSequentialGroup()
                .addContainerGap(272, Short.MAX_VALUE)
                .addComponent(compareTwo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(105, 105, 105)
                .addComponent(compareDB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(86, 86, 86)
                .addComponent(batchProcessing, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(97, 97, 97)
                .addComponent(symetryEstimator, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(272, Short.MAX_VALUE))
        );
        topPanelLayout.setVerticalGroup(
            topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, topPanelLayout.createSequentialGroup()
                .addContainerGap(94, Short.MAX_VALUE)
                .addGroup(topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(symetryEstimator, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(compareDB, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(compareTwo, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(batchProcessing, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        jPanel1.setBackground(new java.awt.Color(20, 114, 105));
        jPanel1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jPanel1MouseDragged(evt);
            }
        });
        jPanel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jPanel1MousePressed(evt);
            }
        });

        newProject.setBackground(new java.awt.Color(20, 114, 105));
        newProject.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 18)); // NOI18N
        newProject.setForeground(new java.awt.Color(255, 255, 255));
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/new_project.png"))); // NOI18N
        newProject.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        newProject.setOpaque(true);
        newProject.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                newProjectMouseMoved(evt);
            }
        });
        newProject.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                newProjectMouseExited(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                newProjectMousePressed(evt);
            }
        });

        close.setBackground(new java.awt.Color(20, 114, 105));
        close.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/close.png"))); // NOI18N
        close.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        close.setOpaque(true);
        close.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                closeMouseMoved(evt);
            }
        });
        close.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                closeMouseExited(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                closeMousePressed(evt);
            }
        });

        wiredModelButton.setBackground(new java.awt.Color(20, 114, 105));
        wiredModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/wireframe.png"))); // NOI18N
        wiredModelButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        wiredModelButton.setOpaque(true);
        wiredModelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                wiredModelButtonMouseClicked(evt);
            }
        });

        homeButton.setBackground(new java.awt.Color(20, 114, 105));
        homeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/home.png"))); // NOI18N
        homeButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        homeButton.setOpaque(true);
        homeButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                homeButtonMouseMoved(evt);
            }
        });
        homeButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                homeButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                homeButtonMouseExited(evt);
            }
        });

        minimize.setBackground(new java.awt.Color(20, 114, 105));
        minimize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/minimize.png"))); // NOI18N
        minimize.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        minimize.setOpaque(true);
        minimize.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                minimizeMouseMoved(evt);
            }
        });
        minimize.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                minimizeMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                minimizeMouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(homeButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(newProject, javax.swing.GroupLayout.PREFERRED_SIZE, 198, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(wiredModelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 187, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(minimize)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(close, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(homeButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(newProject, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(close, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(wiredModelButton, javax.swing.GroupLayout.DEFAULT_SIZE, 77, Short.MAX_VALUE)
                    .addComponent(minimize, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        jPanel2.setLayout(new java.awt.CardLayout());

        startingPanel.setBackground(new java.awt.Color(0, 174, 163));
        startingPanel.setToolTipText("");

        logo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/logo3.png"))); // NOI18N

        jPanel3.setBackground(new java.awt.Color(0, 174, 163));
        jPanel3.setToolTipText("");

        compareTwoMain.setBackground(new java.awt.Color(0, 174, 163));

        JLabel8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/compareTwoStart.png"))); // NOI18N

        javax.swing.GroupLayout compareTwoMainLayout = new javax.swing.GroupLayout(compareTwoMain);
        compareTwoMain.setLayout(compareTwoMainLayout);
        compareTwoMainLayout.setHorizontalGroup(
            compareTwoMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(compareTwoMainLayout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addComponent(JLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        compareTwoMainLayout.setVerticalGroup(
            compareTwoMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMainLayout.createSequentialGroup()
                .addGap(0, 28, Short.MAX_VALUE)
                .addComponent(JLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        compareTwoMain1.setBackground(new java.awt.Color(0, 174, 163));

        JLabel9.setBackground(new java.awt.Color(0, 174, 163));
        JLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/copareWithDatabaseStart.png"))); // NOI18N

        javax.swing.GroupLayout compareTwoMain1Layout = new javax.swing.GroupLayout(compareTwoMain1);
        compareTwoMain1.setLayout(compareTwoMain1Layout);
        compareTwoMain1Layout.setHorizontalGroup(
            compareTwoMain1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMain1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(JLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 196, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        compareTwoMain1Layout.setVerticalGroup(
            compareTwoMain1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMain1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JLabel9, javax.swing.GroupLayout.DEFAULT_SIZE, 156, Short.MAX_VALUE))
        );

        batchMain.setBackground(new java.awt.Color(0, 174, 163));

        JLabel10.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/batchProcessingStart.png"))); // NOI18N

        javax.swing.GroupLayout batchMainLayout = new javax.swing.GroupLayout(batchMain);
        batchMain.setLayout(batchMainLayout);
        batchMainLayout.setHorizontalGroup(
            batchMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, batchMainLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(JLabel10)
                .addContainerGap())
        );
        batchMainLayout.setVerticalGroup(
            batchMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, batchMainLayout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(JLabel10, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        symetryMain.setBackground(new java.awt.Color(0, 174, 163));

        JLabel11.setBackground(new java.awt.Color(0, 174, 163));
        JLabel11.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStart.png"))); // NOI18N
        JLabel11.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        JLabel11.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                JLabel11MouseMoved(evt);
            }
        });
        JLabel11.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                JLabel11MouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                JLabel11MouseExited(evt);
            }
        });

        javax.swing.GroupLayout symetryMainLayout = new javax.swing.GroupLayout(symetryMain);
        symetryMain.setLayout(symetryMainLayout);
        symetryMainLayout.setHorizontalGroup(
            symetryMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(JLabel11, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 189, Short.MAX_VALUE)
        );
        symetryMainLayout.setVerticalGroup(
            symetryMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryMainLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JLabel11, javax.swing.GroupLayout.DEFAULT_SIZE, 167, Short.MAX_VALUE))
        );

        jLabel6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/divide.png"))); // NOI18N

        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/modelView.png"))); // NOI18N
        viewerButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        viewerButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                viewerButtonMouseMoved(evt);
            }
        });
        viewerButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                viewerButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                viewerButtonMouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(169, 169, 169)
                .addComponent(viewerButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 237, Short.MAX_VALUE)
                .addComponent(jLabel6)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(135, 135, 135)
                        .addComponent(compareTwoMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(130, 130, 130)
                        .addComponent(compareTwoMain1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(81, 81, 81)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(batchMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(symetryMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(170, 170, 170))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(compareTwoMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(batchMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(compareTwoMain1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(symetryMain, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(viewerButton)
                .addGap(70, 70, 70))
        );

        javax.swing.GroupLayout startingPanelLayout = new javax.swing.GroupLayout(startingPanel);
        startingPanel.setLayout(startingPanelLayout);
        startingPanelLayout.setHorizontalGroup(
            startingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(startingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
            .addGroup(startingPanelLayout.createSequentialGroup()
                .addGap(643, 643, 643)
                .addComponent(logo, javax.swing.GroupLayout.PREFERRED_SIZE, 218, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        startingPanelLayout.setVerticalGroup(
            startingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(startingPanelLayout.createSequentialGroup()
                .addGap(205, 205, 205)
                .addComponent(logo, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(128, 128, 128)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(200, 200, 200))
        );

        jPanel2.add(startingPanel, "card3");

        symetryPanel.setBackground(new java.awt.Color(0, 174, 163));

        javax.swing.GroupLayout viewerPanelLayout = new javax.swing.GroupLayout(viewerPanel);
        viewerPanel.setLayout(viewerPanelLayout);
        viewerPanelLayout.setHorizontalGroup(
            viewerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(viewerPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(canva1, javax.swing.GroupLayout.DEFAULT_SIZE, 652, Short.MAX_VALUE)
                .addContainerGap())
        );
        viewerPanelLayout.setVerticalGroup(
            viewerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(viewerPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(canva1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        reloadModelButton.setBackground(new java.awt.Color(0, 174, 163));
        reloadModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/loadModel.png"))); // NOI18N
        reloadModelButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        reloadModelButton.setOpaque(true);
        reloadModelButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseMoved(evt);
            }
        });
        reloadModelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseExited(evt);
            }
        });

        exportModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/exportModel.png"))); // NOI18N
        exportModelButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        exportModelButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                exportModelButtonMouseMoved(evt);
            }
        });
        exportModelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exportModelButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                exportModelButtonMouseExited(evt);
            }
        });

        symmetryPanel1.setBackground(new java.awt.Color(176, 230, 226));

        javax.swing.GroupLayout symetryPanelLayout = new javax.swing.GroupLayout(symetryPanel);
        symetryPanel.setLayout(symetryPanelLayout);
        symetryPanelLayout.setHorizontalGroup(
            symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(symetryPanelLayout.createSequentialGroup()
                .addContainerGap(125, Short.MAX_VALUE)
                .addComponent(viewerPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE)
                .addGroup(symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(symmetryPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 580, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(reloadModelButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(exportModelButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap(81, Short.MAX_VALUE))
        );
        symetryPanelLayout.setVerticalGroup(
            symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryPanelLayout.createSequentialGroup()
                .addGap(118, 118, 118)
                .addGroup(symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(symetryPanelLayout.createSequentialGroup()
                        .addComponent(symmetryPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 189, Short.MAX_VALUE)
                        .addComponent(exportModelButton)
                        .addGap(18, 18, 18)
                        .addComponent(reloadModelButton))
                    .addComponent(viewerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(182, 182, 182))
        );

        jPanel2.add(symetryPanel, "card3");

        modelViewPanel.setBackground(new java.awt.Color(0, 174, 163));
        modelViewPanel.setToolTipText("");

        reloadModelButton1.setBackground(new java.awt.Color(0, 174, 163));
        reloadModelButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/loadModel.png"))); // NOI18N
        reloadModelButton1.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        reloadModelButton1.setOpaque(true);
        reloadModelButton1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseMoved(evt);
            }
        });
        reloadModelButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(canva2, javax.swing.GroupLayout.DEFAULT_SIZE, 1040, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(canva2, javax.swing.GroupLayout.PREFERRED_SIZE, 778, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout modelViewPanelLayout = new javax.swing.GroupLayout(modelViewPanel);
        modelViewPanel.setLayout(modelViewPanelLayout);
        modelViewPanelLayout.setHorizontalGroup(
            modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(modelViewPanelLayout.createSequentialGroup()
                .addContainerGap(156, Short.MAX_VALUE)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(60, 60, 60)
                .addComponent(reloadModelButton1)
                .addGap(95, 95, 95))
        );
        modelViewPanelLayout.setVerticalGroup(
            modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, modelViewPanelLayout.createSequentialGroup()
                .addContainerGap(169, Short.MAX_VALUE)
                .addGroup(modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(reloadModelButton1)
                    .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(224, Short.MAX_VALUE))
        );

        jPanel2.add(modelViewPanel, "card4");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(topPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(topPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(847, Short.MAX_VALUE))
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                    .addGap(0, 0, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    /**
     * 
     * @param evt Changes the backround of the new project button
     */
    private void newProjectMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMouseMoved
        setLabelBackround(newProject);
    }//GEN-LAST:event_newProjectMouseMoved

    /**
     * 
     * @param evt Changes back the backround of the new project button
     */
    private void newProjectMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMouseExited
        if (!pressedNewProject) {
            resetLabelBackround(newProject);
        }
    }//GEN-LAST:event_newProjectMouseExited

    /**
     * 
     * @param evt Changes back the backround of the close button
     */
    private void closeMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMouseMoved
        setLabelBackround(close);
    }//GEN-LAST:event_closeMouseMoved

    /**
     * 
     * @param evt Changes back the backround of the close button
     */
    private void closeMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMouseExited
        resetLabelBackround(close);
    }//GEN-LAST:event_closeMouseExited

    /**
     * 
     * @param evt Close the application 
     */
    private void closeMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMousePressed
        System.exit(0);
    }//GEN-LAST:event_closeMousePressed

    /**
     * 
     * @param evt While moved with mouse, symmetry label changes 
     */
    private void jLabel4MouseMoved1(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseMoved1
        jLabel4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStartPanel.png")));
    }//GEN-LAST:event_jLabel4MouseMoved1

    /**
     * 
     * @param evt Shows menu with icons for programs of the app
     */
    private void newProjectMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMousePressed
        if(pressedNewProject) {
            topPanel.setVisible(false);
            pressedNewProject = false;
            switchPanelOnMainPanel(actualPanel);
            newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/new_project.png")));
        }else{
            topPanel.setVisible(true);
            topPanel.add(jPanel1);
            pressedNewProject = true;
            newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/new_project_opened.png")));
        }
    }//GEN-LAST:event_newProjectMousePressed

  
    /**
     * 
     * @param evt Switch to symmetry panel
     */
    private void JLabel11MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseClicked
        switchPanelOnMainPanel(symetryPanel);
    }//GEN-LAST:event_JLabel11MouseClicked

    /**
     * 
     * @param evt Switch to symmetry panel
     */
    private void symetryEstimatorMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryEstimatorMouseClicked
        switchPanelOnMainPanel(symetryPanel);
        topPanel.setVisible(false);
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/new_project.png")));
        resetLabelBackround(newProject);
    }//GEN-LAST:event_symetryEstimatorMouseClicked

    /**
     * 
     * @param evt Enables to move with the window of the app
     */
    private void jPanel1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jPanel1MouseDragged
        int x = evt.getXOnScreen();
        int y = evt.getYOnScreen();
        frameMain.setLocation(x - xMouse, y - yMouse);
    }//GEN-LAST:event_jPanel1MouseDragged

    /**
     * 
     * @param evt Enables to move with the window of the app
     */
    private void jPanel1MousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jPanel1MousePressed
        xMouse  = evt.getX();
        yMouse = evt.getY();
    }//GEN-LAST:event_jPanel1MousePressed

    /**
     * 
     * @param evt Changes the backround of the reload button
     */
    private void reloadModelButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseMoved
        reloadModelButton.setBackground(new Color(176,230,226));
    }//GEN-LAST:event_reloadModelButtonMouseMoved

    /**
     * 
     * @param evt Changes the backround of the reload button
     */
    private void reloadModelButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseExited
        reloadModelButton.setBackground(new Color(0,174,163));
    }//GEN-LAST:event_reloadModelButtonMouseExited

    /**
     * 
     * @param evt Loads the model that will be displayed
     */
    private void reloadModelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseClicked
        canva1.loadModel();
        symmetryPanel1.getOriginalModelButton().setVisible(false);
        symmetryPanel1.getShowPlaneLabel().setVisible(false);
    }//GEN-LAST:event_reloadModelButtonMouseClicked

    /**
     * letting know GLCanva if model will be displayed as wire-frame 
     */
    private void wiredModelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_wiredModelButtonMouseClicked
        if (wiredModelClicked) {
            resetLabelBackround(wiredModelButton);
            wiredModelClicked = false;
            canva1.setDrawWired(wiredModelClicked);
            canva2.setDrawWired(wiredModelClicked);
        } else {
            setLabelBackround(wiredModelButton);
            wiredModelClicked = true;
            canva1.setDrawWired(wiredModelClicked);
            canva2.setDrawWired(wiredModelClicked);
        }
    }//GEN-LAST:event_wiredModelButtonMouseClicked

    /**
     * 
     * @param evt Changes the backround of the home button
     */
    private void homeButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseMoved
        setLabelBackround(homeButton);
    }//GEN-LAST:event_homeButtonMouseMoved

    /**
     * 
     * @param evt Changes the backround of the home button
     */
    private void homeButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseExited
        resetLabelBackround(homeButton);
    }//GEN-LAST:event_homeButtonMouseExited

    /**
     * 
     * @param evt Returns to home panel of the app
     */
    private void homeButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseClicked
        switchPanelOnMainPanel(startingPanel);
    }//GEN-LAST:event_homeButtonMouseClicked

    /**
     * 
     * @param evt Changes the backround of the reload button
     */
    private void reloadModelButton1MouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseMoved
        reloadModelButton1.setBackground(new Color(176,230,226));
    }//GEN-LAST:event_reloadModelButton1MouseMoved

    /**
     * 
     * @param evt Loads the model that will be displayed
     */
    private void reloadModelButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseClicked
        canva2.loadModel();
    }//GEN-LAST:event_reloadModelButton1MouseClicked

    /**
     * 
     * @param evt Changes the backround of the reload button
     */
    private void reloadModelButton1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseExited
        reloadModelButton1.setBackground(new Color(0,174,163));
    }//GEN-LAST:event_reloadModelButton1MouseExited

    /**
     * 
     * @param evt Switch to panel for viewing the model
     */
    private void viewerButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseClicked
        switchPanelOnMainPanel(modelViewPanel);
    }//GEN-LAST:event_viewerButtonMouseClicked

    /**
     * 
     * @param evt Changes the backround of the symmetry button
     */
    private void JLabel11MouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseMoved
        JLabel11.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStartMoved.png")));
    }//GEN-LAST:event_JLabel11MouseMoved

    /**
     * 
     * @param evt Changes the backround of the viewer panel button
     */
    private void viewerButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseMoved
        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/modelViewMoved.png")));
    }//GEN-LAST:event_viewerButtonMouseMoved

    /**
     * 
     * @param evt Changes the backround of the viewer panel button
     */
    private void viewerButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseExited
        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/modelView.png")));
    }//GEN-LAST:event_viewerButtonMouseExited

    /**
     * 
     * @param evt Changes the backround of the symmetry button
     */
    private void JLabel11MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseExited
        JLabel11.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStart.png")));
    }//GEN-LAST:event_JLabel11MouseExited

    /**
     * 
     * @param evt Switch to panel for symmetry
     */
    private void jLabel4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseClicked
        switchPanelOnMainPanel(symetryPanel);
        topPanel.setVisible(false);
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/new_project.png")));
        resetLabelBackround(newProject);
    }//GEN-LAST:event_jLabel4MouseClicked

    /**
     * 
     * @param evt Changes the backround of the export button
     */
    private void exportModelButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportModelButtonMouseMoved
        exportModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/exportModelPressed.png")));
    }//GEN-LAST:event_exportModelButtonMouseMoved

    /**
     * 
     * @param evt Changes the backround of the export button
     */
    private void exportModelButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportModelButtonMouseExited
        exportModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/exportModel.png")));
    }//GEN-LAST:event_exportModelButtonMouseExited

    /**
     * When export button pressed, new directory is created and model is exported to it
     * If there is not loaded model, user is warned
     */
    private void exportModelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportModelButtonMouseClicked
        if (canva1.getModel().getFacets().isEmpty()){
            JOptionPane.showMessageDialog(frameMain, "You have to load the model.", "Model not loaded",
                    0, new ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/notLoadedModel.png")));
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.showSaveDialog(symetryPanel);
            
            MeshModelExporter exporter = new MeshModelExporter(canva1.getModel());
            try {
                if (chooser.getSelectedFile() != null) {
                    exporter.exportModelToObj(chooser.getSelectedFile());
                    JOptionPane.showMessageDialog(frameMain, "Model exported into: " +
                            chooser.getCurrentDirectory().toString() + "\\" + chooser.getSelectedFile().getName(), "Model exported",
                            0, new ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/exportedModel.png")));
                }
            } catch (IOException ex) {
                Logger.getLogger(UserInterface.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_exportModelButtonMouseClicked

    /**
     * 
     * @param evt Changes the backround of the symmetry button
     */
    private void jLabel4MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseExited
        jLabel4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/fidentis/analyst/gui/resources/symetryStartP.png")));
    }//GEN-LAST:event_jLabel4MouseExited

    /**
     * 
     * @param evt Changes the backround of the minimize button
     */
    private void minimizeMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizeMouseMoved
        setLabelBackround(minimize);
    }//GEN-LAST:event_minimizeMouseMoved

    /**
     * 
     * @param evt Changes the backround of the minimize button
     */
    private void minimizeMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizeMouseExited
        resetLabelBackround(minimize);
    }//GEN-LAST:event_minimizeMouseExited

    /**
     * 
     * @param evt Minimize the window of the app
     */
    private void minimizeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizeMouseClicked
        frameMain.setExtendedState(JFrame.ICONIFIED);
    }//GEN-LAST:event_minimizeMouseClicked
   
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(UserInterface.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        java.awt.EventQueue.invokeLater(() -> {
            frameMain = new UserInterface();
            frameMain.setBackground(new Color(49,165,154));
            frameMain.pack();
            frameMain.setVisible(true);
            
            //enables to use design of operating system
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }catch(ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            }
        });
    }
    

    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel JLabel10;
    private javax.swing.JLabel JLabel11;
    private javax.swing.JLabel JLabel8;
    private javax.swing.JLabel JLabel9;
    private javax.swing.JPanel batchMain;
    private javax.swing.JPanel batchProcessing;
    private cz.fidentis.analyst.gui.Canvas canva1;
    private cz.fidentis.analyst.gui.Canvas canva2;
    private javax.swing.JLabel close;
    private javax.swing.JPanel compareDB;
    private javax.swing.JPanel compareTwo;
    private javax.swing.JPanel compareTwoMain;
    private javax.swing.JPanel compareTwoMain1;
    private javax.swing.JLabel exportModelButton;
    private javax.swing.JLabel homeButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JLabel minimize;
    private javax.swing.JPanel modelViewPanel;
    private javax.swing.JLabel newProject;
    private javax.swing.JLabel reloadModelButton;
    private javax.swing.JLabel reloadModelButton1;
    private javax.swing.JPanel startingPanel;
    private javax.swing.JPanel symetryEstimator;
    private javax.swing.JPanel symetryMain;
    private javax.swing.JPanel symetryPanel;
    private cz.fidentis.analyst.gui.SymmetryPanel symmetryPanel1;
    private javax.swing.JPanel topPanel;
    private javax.swing.JLabel viewerButton;
    private javax.swing.JPanel viewerPanel;
    private javax.swing.JLabel wiredModelButton;
    // End of variables declaration//GEN-END:variables
}
