package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.MeshVisitor;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshTriangle;
import java.util.ArrayList;
import java.util.List;

/**
 * A visitor that collects and returns a list of triangles. 
 * It is usefull for collecting triangles of multiple mesh facets.
 * For iterating through triangles of a single facet, use the iterator instead.
 * Or iterate through the facet in a for-each cycle. 
* <p>
 * This visitor is thread-safe. A single instance of the visitor can be used 
 * to inspect multiple mesh models or facets simultaneously.
 * </p>
  *
 * @author Radek Oslejsek
 */
public class TriangleListVisitor extends MeshVisitor {
    
    private List<MeshTriangle> triangles = new ArrayList<>();
    
    /**
     *
     * @param concurrently If {@code true} and this visitor is thread-safe, then
     * the visitor is applied concurrently on multiple mesf facets.
     */
    public TriangleListVisitor(boolean concurrently) {
        super(concurrently);
    }

    @Override
    protected synchronized void visitMeshFacet(MeshFacet facet) {
        for (MeshTriangle tri : facet) {
            triangles.add(tri);
        }
    }
    
    public List<MeshTriangle> getTriangles() {
        return triangles;
    }
}
