package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.MeshVisitor;
import cz.fidentis.analyst.kdtree.KdTree;

import cz.fidentis.analyst.mesh.core.MeshFacet;

import java.util.LinkedList;
import java.util.List;

/**
 * KdTreeBuildVisitor build k-d tree.
 *
 * @author Maria Kocurekova
 */

public class KdTreeBuildVisitor extends MeshVisitor {
    
    private List<MeshFacet> facets = new LinkedList<>();
    
    /**
     *
     * @param concurrently If {@code true} and this visitor is thread-safe, then
     * the visitor is applied concurrently on multiple mesf facets.
     */
    public KdTreeBuildVisitor(boolean concurrently) {
        super(concurrently);
    }

    @Override
    protected void visitMeshFacet(MeshFacet facet) {
        this.facets.add(facet);
    }


    /**
     * Returns k-d tree.
     *
     * @return k-d tree
     */
    public KdTree getKdTree() {
        return new KdTree(facets);
    }
    
}
