package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.MeshVisitor;
import cz.fidentis.analyst.mesh.core.MeshFacet;

/**
 * Visitor that computes a 3D bounding box (cube).
 * <p>
 * This visitor is thread-safe. A single instance of the visitor can be used 
 * to inspect multiple mesh models or facets simultaneously.
 * </p>
 * 
 * @author Radek Oslejsek
 */
public class BoundingBoxVisitor extends MeshVisitor {

    private BoundingBox bbox;
    
    /**
     *
     * @param concurrently If {@code true} and this visitor is thread-safe, then
     * the visitor is applied concurrently on multiple mesf facets.
     */
    public BoundingBoxVisitor(boolean concurrently) {
        super(concurrently);
    }
    
    @Override
    protected synchronized void visitMeshFacet(MeshFacet facet) {
        if (bbox == null) {
            bbox = new BoundingBox(facet.getVertices());
        } else {
            bbox.compute(facet.getVertices());
        }
    }
    
    /**
     * Returns computed bounding box.
     * 
     * @return Bounding box or null
     */
    public BoundingBox getBoundingBox() {
        return bbox;
    }
}
