package cz.fidentis.analyst.symmetry;

import javax.vecmath.Vector3d;

/**
 * Symmetry plane.
 * 
 * @author Natalia Bebjakova
 */
public class Plane {
   
    private Vector3d normal;
    private double   distance;

    /**
     * Creates new plane.
     * 
     * @param a a coordinate 
     * @param b b coordinate
     * @param c c coordinate
     * @param d d coordinate
     */
    public Plane(double a, double b, double c, double d) {
        normal = new Vector3d(a,b,c);
        distance = d;
    }
    
    /**
     * Constructor.
     * @param normal Normal vector of the plane
     * @param dist distance
     * @throws IllegalArgumentExpcption if the @code{plane} argument is null
     */
    public Plane(Vector3d normal, double dist) {
        this(normal.x, normal.y, normal.z, dist);
    }
    
    /**
     * Copy constructor.
     * @param plane original plane
     * @throws IllegalArgumentExpcption if the @code{plane} argument is null
     */
    public Plane(Plane plane) {
        this(plane.getNormal(), plane.getDistance());
    }
    
    /**
     * Normalize the plane
     */
    public void normalize() {
        double normalLength = normal.length();
        normal.normalize();
        distance /= normalLength; // Do we really want this? --ro
    }
    
    /**
     * Returns string description of the plane
     * 
     * @return description of the plane
     */
    @Override
    public String toString(){
        return "APPROXIMATE PLANE:" + System.lineSeparator() + 
                normal.x + System.lineSeparator() + 
                normal.y + System.lineSeparator() + 
                normal.z + System.lineSeparator() + 
                distance + System.lineSeparator();
    }
    
    public Vector3d getNormal() {
        return normal;
    }
    
    public double getDistance() {
        return distance;
    }
}
