package cz.fidentis.analyst.symmetry;

/**
 * 
 * Symmetry plane with votes used for the decision about symmetry estimate of 3D models.
 *
 * @author Natalia Bebjakova
 * 
 */
public class ApproxSymmetryPlane extends Plane implements Comparable<ApproxSymmetryPlane> {
    
    private int votes;

    /**
     * returns number of votes that were given to plane while computing the symmetry 
     * 
     * @return Number of votes 
     */
    public int getVotes() {
        return votes;
    }

    /**
     * Constructor.
     * @param plane Original plane without votes 
     * @param votes number of votes given to the plane
     * @throws IllegalArgumentExpcption if the @code{plane} argument is null
     */
    public ApproxSymmetryPlane(Plane plane, int votes) {
        super(plane);
        this.votes = votes;
    }
    
    /**
     * Enables to compare two approximate planes due to number of votes 
     * 
     * @param other plane to be compared 
     * @return number that decides which plane has more votes 
     */
    @Override
    public int compareTo(ApproxSymmetryPlane other) {
        return Integer.compare(votes, other.votes);
    }
}
