package cz.fidentis.analyst.face;

import cz.fidentis.analyst.kdtree.KdTree;
import cz.fidentis.analyst.kdtree.KdTreeEvent;

/**
 * Event indicating that a new kd-tree has been buit.
 * The old tree is stored in the event.
 * 
 * @author Radek Oslejsek
 */
public class KdTreeBuiltEvent implements KdTreeEvent {
    
    private KdTree oldTree;
    
    /**
     * 
     * @param oldTree Old kd-tree. Can be {@code null}
     */
    public KdTreeBuiltEvent(KdTree oldTree) {
        this.oldTree = oldTree;
    }

    public KdTree getOldTree() {
        return oldTree;
    }
}
