package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.MeshVisitor;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshTriangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A visitor that collects and returns a list of triangles. 
 * It is useful for collecting triangles of multiple mesh facets.
 * For iterating through triangles of a single facet, use the iterator instead.
 * Or iterate through the facet in a for-each cycle. 
 * <p>
 * This visitor is thread-safe.
 * </p>
 *
 * @author Radek Oslejsek
 */
public class TriangleListVisitor extends MeshVisitor {
    
    private List<MeshTriangle> triangles = new ArrayList<>();
    
    @Override
    public void visitMeshFacet(MeshFacet facet) {
        synchronized (this) {
            triangles.addAll(facet.getTriangles());
        }
    }
    
    public List<MeshTriangle> getTriangles() {
        return Collections.unmodifiableList(triangles);
    }
}
