package cz.fidentis.analyst.mesh.io;

import javax.swing.filechooser.FileFilter;
import java.io.File;

/**
 * @author Natália Bebjaková
 * 
 * Class that enables to choose just extensions we want in the filechooser 
 */
public class ModelFileFilter extends FileFilter {

    private final String[] extension;
    private final String description;
    
    /**
     * 
     * @param extension Extentions of files
     * @param description Description
     */
    public ModelFileFilter(String[] extension, String description)
    {
        this.extension = extension;
        this.description = description;
    }

    /**
     * 
     * @param f File 
     * @return Whether file has chosen extension or not 
     */
    @Override
    public boolean accept(File f)
    {
        boolean accepted = false;
        for (String extension1 : extension) {
            if (f.isDirectory() || f.getName().endsWith(extension1)) {
                accepted = true;
            }
        }
        return accepted;
    }
    
    /**
     * 
     * @return description
     */
    @Override
    public String getDescription() {
        return description;
    }

}