package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MashFacet
 *
 * @author Matej Lukes
 */
public class MeshFacet {
    private List<MeshPoint> vertices = new ArrayList<>();
    private CornerTable cornerTable;

    /**
     * Constructor of MeshFacet
     */
    public MeshFacet() {
        cornerTable = new CornerTable();
    }

    /**
     * Copy constructor of MeshFacet
     *
     * @param facet copied MeshFacet
     */
    public MeshFacet(MeshFacet facet) {
        for (MeshPoint vertex :
                facet.vertices) {
            vertices.add(new MeshPoint(vertex));
        }
        cornerTable = new CornerTable(facet.cornerTable);
    }

    /**
     * returns vertex of specified index
     *
     * @param index index of vertex
     * @return vertex
     */
    public MeshPoint getVertex(int index) {
        return vertices.get(index);
    }

    /**
     * adds vertex to MeshFacet
     *
     * @param point new vertex
     */
    public void addVertex(MeshPoint point) {
        vertices.add(point);
    }

    /**
     * returns number of vertices in MeshFacet
     *
     * @return number of vertices
     */
    public int getNumberOfVertices() {
        return vertices.size();
    }

    /**
     * returns list of vertices in MeshFacet
     *
     * @return list if vertices
     */
    public List<MeshPoint> getVertices() {
        return vertices;
    }

    /**
     * returns Corner Table representing MeshFacet
     *
     * @return corner table
     */
    public CornerTable getCornerTable() {
        return cornerTable;
    }
}

