package cz.fidentis.analyst.newgui.swing;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;

/**
 *
 * @author oslejsek
 */
public class CanvasListener implements GLEventListener {
    
    private CanvasPanel canvas;
    
    /**
     * Constructor.
     * 
     * @param canvas Canvas
     * @throws IllegalArgumentException if the canvas is {@code null}
     */
    public CanvasListener(CanvasPanel canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this.canvas = canvas;
    }
    
    @Override
    public void init(GLAutoDrawable glad) {
        canvas.getScene().initSceneGLContext(glad.getGL().getGL2());
    }

    @Override
    public void dispose(GLAutoDrawable glad) {
    }

    @Override
    public void display(GLAutoDrawable glad) {
        canvas.getScene().clearScene();
        canvas.getScene().renderScene();
    }

    @Override
    public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {
        System.out.println("CanvasListener.reshape");
        canvas.getScene().setViewport(x, y, width, height);
    }
    
}
