package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * Representation of mesh in memory
 */
public class CornerTable {

    private List<CornerTableRow> rows = new ArrayList<>();

    /**
     * returns index of face that contains corner
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfFace(int c) {
        return c / 3;
    }

    /**
     * returns index of opposite corner
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfOppositeCorner(int c) {
        return rows.get(c).getOppositeCornerIndex();
    } // opposite

    /**
     * returns index of next corner in Face
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfNextCornerInFace(int c) {
        if ((c % 3) == 2)
            return c - 1;
        return c + 1;
    }// next in t(c)

    /**
     * returns index of previous corner in Face
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfPreviousCornerInFace(int c) {
        return getIndexOfNextCornerInFace(getIndexOfNextCornerInFace(c));
    } // previous corner

    /**
     * returns opposite corner of edge on the left side of corner
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfTipCornerOnLeft(int c) {
        return getIndexOfOppositeCorner(getIndexOfPreviousCornerInFace(c));
    }  // tip on left

    /**
     * returns opposite corner of edge on the right side of corner
     * @param c index of corner
     * @return index of corner
     */
    public int getIndexOfTipCornerOnRight(int c) {
        return getIndexOfOppositeCorner(getIndexOfNextCornerInFace(c));
    } // tip on right

    /**
     * returns corner next to the corner opposite the edge on the left side
     * @param c index of corner
     * @return index of corner
     */
    public int getNextAroundCorner(int c) {
        return getIndexOfNextCornerInFace(getIndexOfTipCornerOnLeft(c));
    } // next around v(c)

    /**
     * adds row to the corner table
     * @param row that is going to be added to corner table
     */
    public void addRow(CornerTableRow row) {
        rows.add(row);
    }

    /**
     * replaces row of corner table at specified index
     * @param index index of replaced row
     * @param row new row
     */
    public void replaceRow(int index, CornerTableRow row) {
        rows.set(index, row);
    }
}
