package cz.fidentis.analyst.feature;

import java.io.Serializable;
import javax.vecmath.Point3d;

/**
 *
 * @author kubok
 */
public class FeaturePoint implements Serializable {

    private final Point3d position;
    private final FeaturePointType FEATURE_POINT_TYPE;

    /**
     * Constructor.
     * 
     * @param x Location x 
     * @param y Location y
     * @param z Location z
     * @param featurePointType Original type
     */
    public FeaturePoint(double x, double y, double z, FeaturePointType featurePointType) {
        this.position = new Point3d(x, y, z);
        this.FEATURE_POINT_TYPE = featurePointType;
    }
    
    public Point3d getPosition() {
        return position;
    }
    
    public double getX() {
        return position.x;
    }

    public double getY() {
        return position.y;
    }

    public double getZ() {
        return position.z;
    }

    public FeaturePointType getFeaturePointType() {
        return FEATURE_POINT_TYPE;
    }
}
