package cz.fidentis.analyst.mesh.events;

import cz.fidentis.analyst.mesh.core.MeshFacet;

/**
 * An event fired by the {@see cz.fidentis.analyst.mesh.MeshModel} when 
 * a new mesh facet has been added.

 * @author Radek Oslejsek
 */
public class FacetAddedEvent implements MeshEvent {
    
    private final MeshFacet facet;
    
    /**
     * 
     * @param facet Mesdh Facet
     */
    public FacetAddedEvent(MeshFacet facet) {
        this.facet = facet;
    }

    public MeshFacet getFacet() {
        return facet;
    }
}
