/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.procrustes.utils;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.api.IPosition;
import cz.fidentis.analyst.feature.provider.FeaturePointTypeProvider;
import cz.fidentis.analyst.mesh.core.MeshPoint;
import cz.fidentis.analyst.procrustes.ProcrustesAnalysisFaceModel;
import org.ejml.simple.SimpleMatrix;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import java.util.*;

/**
 * @author Jakub Kolman
 */
public class ProcrustesAnalysisUtils {

    /**
     * Sorts List by featurePoint type property
     *
     * @param featurePointList
     * @return ordered list of feature points by type
     */
    public static List<FeaturePoint> sortListByFeaturePointType(List<FeaturePoint> featurePointList) {
        Collections.sort(
                featurePointList, Comparator.comparingInt(fp -> fp.getFeaturePointType().getType())
        );
        return featurePointList;
    }

    /**
     * Checks if two feature point lists have the same types of feature points.
     * <p>
     * To use this method you need to supply ordered lists by Feature Point type
     * as parameters. Otherwise even if two lists contain the same featurepoints
     * it will return false.
     * <p>
     * Use sort function {@link #sortListByFeaturePointType} on feature point lists
     * two get correct results.
     *
     * @param featurePointList1
     * @param featurePointList2
     * @return true if two sorted lists by the feature point type contain the
     * same feature point types
     */
    public static boolean checkFeaturePointsType(List<FeaturePoint> featurePointList1, List<FeaturePoint> featurePointList2) {
        for (int i = 0; i < featurePointList1.size(); i++) {
            if (featurePointList1.get(i).getFeaturePointType().getType() != featurePointList2.get(i).getFeaturePointType().getType()) {
                System.out.print(featurePointList1.get(i).getFeaturePointType().getType());
                System.out.print(featurePointList2.get(i).getFeaturePointType().getType());
                return false;
            }
        }
        return true;
    }

    /**
     * Finds centrioid from given feature point List
     *
     * @param featurePointList
     * @return centroid of feature points (Vector3F)
     */
    public static Point3d findCentroidOfFeaturePoints(List<FeaturePoint> featurePointList) {
        float x = 0;
        float y = 0;
        float z = 0;
        for (FeaturePoint fp : featurePointList) {
            x += fp.getX();
            y += fp.getY();
            z += fp.getZ();
        }
        return new Point3d(x / featurePointList.size(), y / featurePointList.size(), z / featurePointList.size());
    }

    /**
     * Creates matrix from given feature point list
     *
     * @param list
     * @return matrix
     */
    public static <T extends IPosition> SimpleMatrix createMatrixFromList(List<T> list) {
        SimpleMatrix matrix = new SimpleMatrix(list.size(), 3);
        for (int i = 0; i < list.size(); i++) {
            matrix.set(i, 0, list.get(i).getPosition().x);
            matrix.set(i, 1, list.get(i).getPosition().y);
            matrix.set(i, 2, list.get(i).getPosition().z);
        }
        return matrix;
    }

    /**
     * Creates feature point map HashMap with key FeaturePoint.type and value FeaturePoint back from matrix.
     *
     * @param matrix
     * @param model
     * @return
     */
    public static HashMap<Integer, FeaturePoint> createFeaturePointMapFromMatrix(
            SimpleMatrix matrix, ProcrustesAnalysisFaceModel model) {
        HashMap<Integer, FeaturePoint> map = new HashMap<>();
        for (int i = 0; i < matrix.numRows(); i++) {
            FeaturePoint featurePoint = new FeaturePoint(
                    matrix.get(i, 0),
                    matrix.get(i, 1),
                    matrix.get(i, 2),
                    model.getFeaturePointsMap().get(
                            model.getFeaturePointTypeCorrespondence().get(i)
                    ).getFeaturePointType()
            );
            map.put(model.getFeaturePointTypeCorrespondence().get(i), featurePoint);
        }
        return map;
    }

}
