package cz.fidentis.analyst.distance;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.core.ControlPanelBuilder;
import cz.fidentis.analyst.symmetry.SymmetryPanel;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;

/**
 * Control panel for Hausdorff distance.
 * 
 * @author Radek Oslejsek
 */
public class DistancePanel extends ControlPanel {
    
    /*
     * Mandatory design elements
     */
    public static final String ICON = "distance28x28.png";
    public static final String NAME = "Hausdorff distance";
    
    /*
     * External actions
     */
    public static final String ACTION_COMMAND_SHOW_HIDE_HEATMAP = "show-hide heatmap";
    public static final String ACTION_COMMAND_SET_DISTANCE_STRATEGY = "set strategy";
    public static final String ACTION_COMMAND_RELATIVE_ABSOLUTE_DIST = "switch abosulte-relative distance";
    
    /*
     * Configuration of panel-specific GUI elements
     */
    public static final String  STRATEGY_POINT_TO_POINT= "Point to point";
    public static final String  STRATEGY_POINT_TO_TRIANGLE= "Point to triangle";
    
    /**
     * Constructor.
     * @param action Action listener
     */
    public DistancePanel(ActionListener action) {
        this.setName(NAME);
        
        ControlPanelBuilder builder = new ControlPanelBuilder(this);
        
        builder.addCaptionLine("Computation options:");
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "Relative distance", 
                false,
                createListener(action, ACTION_COMMAND_RELATIVE_ABSOLUTE_DIST)
        );
        builder.addLine();
        
        builder.addOptionText("Distance strategy");
        builder.addComboBox(
                List.of(STRATEGY_POINT_TO_POINT, STRATEGY_POINT_TO_TRIANGLE),
                createListener(action, ACTION_COMMAND_SET_DISTANCE_STRATEGY)
        );
        builder.addGap();
        builder.addLine();
        
        builder.addCaptionLine("Visualization options:");
        builder.addLine();
        builder.addCheckBoxOptionLine(
                null, 
                "Show Hausdorff distance", 
                false,
                createListener(action, ACTION_COMMAND_SHOW_HIDE_HEATMAP)
        ); 
        builder.addLine();
        builder.addVerticalStrut();
    }
    
    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }
    
    /**
     * Static implementation of the {@link #getIcon()} method.
     * 
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(SymmetryPanel.class.getClassLoader().getResource("/" + ICON));
    }
}
