package cz.fidentis.analyst.artefacts;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

/**
 *
 * @author oslejsek
 */
public class DoubleInputGroup extends JPanel {
    
    public static final String ACTION_COMMAND_RESET = "values reset";
    
    private List<DoubleInputField> inputFields = new ArrayList<>();
    
    public DoubleInputGroup(List<String> labels, List<String> commands, String groupLabel, double val, double step, ActionListener action) {
        if (groupLabel != null) {
            setBorder(BorderFactory.createTitledBorder(groupLabel));
        }
        
        setLayout(new GridLayout(1, commands.size() + 1));
        
        for (int i = 0; i < labels.size(); i++) {
            final int finalI = i;
            inputFields.add(new DoubleInputField(val, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, step, labels.get(i), 
                    new AbstractAction() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            action.actionPerformed(new ActionEvent(
                                    e.getSource(), 
                                    ActionEvent.ACTION_PERFORMED, 
                                    DoubleInputField.ACTION_COMMAND_INPUT_CHANGED + " " + finalI)
                            ); 
                        }
                    })
            );
            add(inputFields.get(i));
        }
        
        JButton resetButton = new JButton();
        resetButton.setText("reset");
        resetButton.setFocusPainted(false);
        add(resetButton);
        
        resetButton.addChangeListener((ChangeEvent evt) -> {
            for (DoubleInputField dif: inputFields) {
                dif.setValue(val);
            }
            action.actionPerformed(new ActionEvent(
                    evt.getSource(),
                    ActionEvent.ACTION_PERFORMED, 
                    ACTION_COMMAND_RESET)
            ); 
        });
    }
}
