package cz.fidentis.analyst.artefacts;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

/**
 *
 * @author Radek Oslejsek
 */
public class DoubleInputField extends JPanel {
    
    /*
     * Fired actions
     */
    public static final String ACTION_COMMAND_INPUT_CHANGED = "value changed";
    
    private final SpinnerNumberModel model;
    private final JSpinner spinner;
    
    public DoubleInputField(double value, double min, double max, double step, String label, ActionListener action) {
        setLayout(new GridLayout(1, 2));
        
        JLabel jLabel = new JLabel((label != null) ? label : "");
        add(jLabel);
        
        model = new SpinnerNumberModel(value, min, max, step);
        spinner = new JSpinner(model);
        add(spinner);
        
        spinner.addChangeListener((ChangeEvent evt) -> {
            action.actionPerformed(new ActionEvent(
                    evt.getSource(),
                    ActionEvent.ACTION_PERFORMED, 
                    ACTION_COMMAND_INPUT_CHANGED)
            ); 
        });
    }
    
    public double getValue() {
        return model.getNumber().doubleValue();
    }
    
    public void setValue(double value) {
        model.setValue(value);
    }
}
