package cz.fidentis.analyst.scene;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.symmetry.Plane;

/**
 * A cutting plane.
 * 
 * @author Radek Oslejsek
 */
public class DrawablePlane extends DrawableMesh {
    
    private final Plane plane;
    
    /**
     * Constructor.
     * @param model Mesh model of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshModel model, Plane plane) {
        super(model);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = plane;
    }
    
    /**
     * Constructor.
     * @param facet Mesh facet of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshFacet facet, Plane plane) {
        super(facet);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = plane;
    }
}
