/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.tests;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.icp.IcpTransformer;
import cz.fidentis.analyst.icp.NoUndersampling;
import cz.fidentis.analyst.kdtree.KdTree;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author oslejsek
 */
public class ICPTest {
    
    private static final String dataDir = "../../analyst-data/multi-scan-models-anonymized-fixed/";
    
    private static String[] faceFiles = new String[] {
        dataDir + "02/00002_01_ECA.obj",
        dataDir + "04/00004_01_ECA.obj",
        dataDir + "06/00006_01_ECA.obj",
        dataDir + "07/00007_01_ECA.obj",
        dataDir + "10/00010_01_ECA.obj"
    };
    
    private static int tests = 0;
    private static int iters = 0;
    
    public static void main(String[] args) throws IOException {
        long time = 0;
        for (int i = 0; i < faceFiles.length; i++) {
            time += test(i);
        }
        System.out.println("tests: " + tests);
        System.out.println("iters: " + iters);
        System.out.println("time: " + time + " ms");
        System.out.println("AVG iters: " + ((double)iters/tests));
        System.out.println("AVG time: " + ((double)time/tests) + " ms");
    }
    
    public static long test(int index) throws IOException {
        List<HumanFace> faces = new ArrayList<>();
        for (int i = 0; i < faceFiles.length; i++) {
            faces.add(new HumanFace(new File(faceFiles[i])));
        }
        HumanFace prim = faces.remove(index);
        KdTree primKdTree = prim.computeKdTree(true);
        
        
        System.out.println();
        System.out.println(prim.getId());            
        long startTime = System.currentTimeMillis();
        for (HumanFace sec: faces) {
            tests++;
            IcpTransformer icpTransformer = new IcpTransformer(primKdTree, 10, false, 0.05, new NoUndersampling());
            System.out.println(sec.getId());
            sec.getMeshModel().compute(icpTransformer);
            
            for (MeshFacet f: icpTransformer.getTransformations().keySet()) {
                //System.out.println("AAA"+icpTransformer.getTransformations().get(f).size());
                iters += icpTransformer.getTransformations().get(f).size();
            }
        }
        long endTime = System.currentTimeMillis();
        
        return endTime - startTime;
    }
}
