package cz.fidentis.analyst.registration;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.face.HumanFaceFactory;
import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.gui.ProjectTopComp;
import cz.fidentis.analyst.gui.scene.DrawableFace;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;

/**
 * Top component used to test registration adjustment.
 * 
 * @author Richard Pajersky
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//RegistrationTest//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "PostRegistrationTestTC",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "properties", openAtStartup = false)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.PostRegistrationTestTC")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_RegistrationTestAction",
        preferredID = "PostRegistrationTestTC"
)
@Messages({
    "CTL_RegistrationTestAction=RegistrationTest",
    "CTL_RegistrationTestTopComponent=RegistrationTest Window",
    "HINT_RegistrationTestTopComponent=This is a RegistrationTest window"
})
public final class PostRegistrationTestTC extends TopComponent {

    /**
     * Constructor
     */
    public PostRegistrationTestTC() {
        initComponents();
        setName(Bundle.CTL_RegistrationTestTopComponent());
        setToolTipText(Bundle.HINT_RegistrationTestTopComponent());
        
        File file1 = new FileChooserBuilder(ProjectTopComp.class)
                .setTitle("Open human face(s)")
                .setDefaultWorkingDirectory(new File (System.getProperty("user.home")))
                //.setApproveText("Add")
                .setFileFilter(new FileNameExtensionFilter("obj files (*.obj)", "obj"))
                .setAcceptAllFileFilterUsed(true)
                .showOpenDialog();
        
        File file2 = new FileChooserBuilder(ProjectTopComp.class)
                .setTitle("Open human face(s)")
                .setDefaultWorkingDirectory(new File (System.getProperty("user.home")))
                //.setApproveText("Add")
                .setFileFilter(new FileNameExtensionFilter("obj files (*.obj)", "obj"))
                .setAcceptAllFileFilterUsed(true)
                .showOpenDialog();
        
        String primFaceId = HumanFaceFactory.instance().loadFace(file1);
        String secFaceId = HumanFaceFactory.instance().loadFace(file2);
        HumanFace primary = HumanFaceFactory.instance().getFace(primFaceId);
        HumanFace secondary = HumanFaceFactory.instance().getFace(secFaceId);

        canvas1.initScene(primary, secondary); // init canvas
        
        /* feature points test */
        List<DrawableFace> drawables = new ArrayList<>(canvas1.getScene().getDrawables());
        DrawableFace primaryFace = drawables.get(0);
        DrawableFace secondaryFace = drawables.get(1);
        
        ArrayList<FeaturePoint> primar = new ArrayList<>();
        primar.add(new FeaturePoint(100, 0, 0, null));
        primaryFace.setFeaturePoints(primar);
        
        ArrayList<FeaturePoint> secondar = new ArrayList<>();
        secondar.add(new FeaturePoint(101, 0, 0, null));
        secondaryFace.setFeaturePoints(secondar);
        
        postRegistrationCP1.initPostRegistrationCP(new PostRegistrationListener(canvas1));
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        canvas1 = new cz.fidentis.analyst.gui.canvas.Canvas();
        postRegistrationCP1 = new cz.fidentis.analyst.registration.PostRegistrationCP();

        setPreferredSize(new java.awt.Dimension(405, 600));

        javax.swing.GroupLayout postRegistrationCP1Layout = new javax.swing.GroupLayout(postRegistrationCP1);
        postRegistrationCP1.setLayout(postRegistrationCP1Layout);
        postRegistrationCP1Layout.setHorizontalGroup(
            postRegistrationCP1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 340, Short.MAX_VALUE)
        );
        postRegistrationCP1Layout.setVerticalGroup(
            postRegistrationCP1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(canvas1, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(postRegistrationCP1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(canvas1, javax.swing.GroupLayout.DEFAULT_SIZE, 708, Short.MAX_VALUE)
            .addComponent(postRegistrationCP1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private cz.fidentis.analyst.gui.canvas.Canvas canvas1;
    private cz.fidentis.analyst.registration.PostRegistrationCP postRegistrationCP1;
    // End of variables declaration//GEN-END:variables
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
