package cz.fidentis.analyst.gui.tab;

import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.gui.core.ControlPanelTC;
import cz.fidentis.analyst.gui.rndtoolbar.RenderingToolBar;
import cz.fidentis.analyst.gui.rndtoolbar.SingleFaceToolBar;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.windows.TopComponent;

/**
 * The non-singleton window/tab for detail inspection of a single face.
 * For the discussion on crating non-singleton top component, 
 * see {@link http://netbeans.apache.org/wiki/DevFaqNonSingletonTopComponents.asciidoc}.
 *
 * @author Radek Oslejsek
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui.tab//SingleFaceTab//EN",
        autostore = false
)
public final class SingleFaceTab extends TopComponent {
    
    private final Canvas canvas = new Canvas();
    private final RenderingToolBar renderingToolBar;
    private final ControlPanelTC controlPanel;

    /**
     * Constructor.
     */
    public SingleFaceTab() {
        controlPanel = new ControlPanelTC();
        renderingToolBar = new SingleFaceToolBar(canvas, controlPanel);
        initComponents();
    }
    
    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER; // TO DO: change to .PERSISTENCE_ONLY_OPENED when we can re-create the ProjectTC
    }
    
    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(canvas, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addComponent(controlPanel, GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(renderingToolBar)
                                        .addComponent(canvas)
                                        .addComponent(controlPanel)
                                ))
        );
    }

    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
    
    public Canvas getCanvas() {
        return canvas;
    }
}
