package cz.fidentis.analyst.gui.scene;

import cz.fidentis.analyst.face.HumanFace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Abstract class for ...
 * 
 * @author Radek Oslejsek
 */
public class Scene {
    
    private final HumanFace primaryFace;
    
    private final HumanFace secondaryFace ;
    
    private final List<DrawableFace> drawables = new ArrayList<>();
    
    /**
     * Constructor for single face analysis.
     * 
     * @param face Human face to be analyzed
     * @throws IllegalArgumentException if the {@code face} is {@code null}
     */
    public Scene(HumanFace face) {
        if (face == null) {
            throw new IllegalArgumentException("face");
        }
        this.primaryFace = face;
        this.secondaryFace = null;
        
        drawables.add(new DrawableFace(primaryFace.getMeshModel()));
    }
    
    /**
     * Constructor for one-to-one analysis.
     * 
     * @param primary Primary face to be analyzed
     * @param primary Secondary face to be analyzed
     * @throws IllegalArgumentException if some face is {@code null}
     */
    public Scene(HumanFace primary, HumanFace secondary) {
        if (primary == null) {
            throw new IllegalArgumentException("primary");
        }
        if (secondary == null) {
            throw new IllegalArgumentException("secondary");
        }
        this.primaryFace = primary;
        this.secondaryFace = secondary;
        
        drawables.add(new DrawableFace(primaryFace.getMeshModel()));
        drawables.add(new DrawableFace(secondaryFace.getMeshModel()));
    }
    
    /**
     * Returns all drawable objects in a modifiable collection (should be refactored in the future).
     * 
     * @return all drawable objects 
     */
    public List<DrawableFace> getDrawables() {
        return this.drawables;
    }
    
    /*public void setDrawables(Collection<DrawableMesh> drawables) {
        this.drawables = this.drawables;
    }*/
    
}
