package cz.fidentis.analyst.gui.scene;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import cz.fidentis.analyst.feature.FeaturePoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author oslejsek
 */
public class DrawableFeaturePoints extends Drawable {
    
    public static final Color DEFAULT_COLOR = Color.GREEN;
    
    private static final GLU glu = new GLU();
    
    /* feature points */
    private final List<FeaturePoint> featurePoints;
    
    /**
     * feature points with color different from the default color
     */
    private Map<Integer, Color> specialColors = new HashMap<>();
    
    /**
     * Constructor.
     * @param featurePoints Feature points
     */
    public DrawableFeaturePoints(List<FeaturePoint> featurePoints) {
        this.featurePoints = new ArrayList<>(featurePoints);
        setColor(DEFAULT_COLOR);
    }

    @Override
    protected void renderObject(GL2 gl) {
        float[] rgba = {
            getColor().getRed() / 255f, 
            getColor().getGreen() / 255f, 
            getColor().getBlue() / 255f, 
            getTransparency()
        };
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, rgba, 0); // set default color
        
        for (int i = 0; i < featurePoints.size(); i++) {
            FeaturePoint fp = featurePoints.get(i);
            Color specialColor = specialColors.get(i);
            if (specialColor != null) {
                float[] tmpRGB = {specialColor.getRed() / 255f, specialColor.getGreen() / 255f, specialColor.getBlue() / 255f, getTransparency()};
                gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, tmpRGB, 0);
            }
            
            //gl.glPushMatrix(); 
            //gl.glTranslated(fp.getX(), fp.getY(), fp.getZ());
            GLUquadric center = glu.gluNewQuadric();
            glu.gluQuadricDrawStyle(center, GLU.GLU_FILL);
            glu.gluQuadricNormals(center, GLU.GLU_FLAT);
            glu.gluQuadricOrientation(center, GLU.GLU_OUTSIDE);
            glu.gluSphere(center, 3f, 16, 16);
            glu.gluDeleteQuadric(center);
            //gl.glPopMatrix();
    
            if (specialColor != null) {
                gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, rgba, 0); // set default color
            }
        }
    }
       
    /**
     * @return {@link List} of {@link FeaturePoint}
     */
    //public List<FeaturePoint> getFeaturePoints() {
    //    return Collections.unmodifiableList(featurePoints);
    //}

    /**
     * Sets feature points
     * @param featurePoints Feature points
     */
    /*
    public void setFeaturePoints(List<FeaturePoint> featurePoints) {
        this.featurePoints = featurePoints;
        List<Color> colors = new ArrayList<>();
        featurePoints.forEach((_item) -> {
            colors.add(getColor());
        });
        this.setFeaturePointsColor(colors);
    } 
    */
    
}
