package cz.fidentis.analyst.gui.scene;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author oslejsek
 */
public class DrawableFace extends DrawableMesh {
    
    public static final Color SKIN_COLOR = new Color(224, 172, 105);
    
    /* feature points */
    private List<FeaturePoint> featurePoints = new ArrayList<>();
    private List<Color> featurePointsColor = new ArrayList<>();
    private boolean renderFeaturePoints = false;
    
    /**
     * Constructor. 
     * 
     * @param model Drawable mesh model of the face
     * @throws IllegalArgumentException if the model is {@code null}
     */
    public DrawableFace(MeshModel model) {
        super(model);
        setColor(SKIN_COLOR);
    }
    
    /**
     * @return {@link List} of {@link FeaturePoint}
     */
    public List<FeaturePoint> getFeaturePoints() {
        return featurePoints;
    }

    /**
     * Sets feature points
     * @param featurePoints Feature points
     */
    public void setFeaturePoints(List<FeaturePoint> featurePoints) {
        this.featurePoints = featurePoints;
        List<Color> colors = new ArrayList<>();
        featurePoints.forEach((_item) -> {
            colors.add(getColor());
        });
        this.setFeaturePointsColor(colors);
    }   
    
    /**
     * @return {@link List} of feature points {@link Color}
     */
    public List<Color> getFeaturePointsColor() {
        return featurePointsColor;
    }

    /**
     * Sets colors of feature points
     * @param featurePointsColor Colors of feature points
     */
    public void setFeaturePointsColor(List<Color> featurePointsColor) {
        this.featurePointsColor = featurePointsColor;
    } 
    
    /**
     * @return {@code true} if feature points should be rendered
     */
    public boolean isRenderFeaturePoints() {
        return renderFeaturePoints;
    }

    /**
     * Sets if feature points should be renderred or not
     * @param renderFeaturePoints 
     */
    public void setRenderFeaturePoints(boolean renderFeaturePoints) {
        this.renderFeaturePoints = renderFeaturePoints;
    }    
}
