package cz.fidentis.analyst.gui.rndtoolbar;

import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.symmetry.SignificantPoints.CurvatureAlg;
import cz.fidentis.analyst.symmetry.SymmetryConfig;
import cz.fidentis.analyst.symmetry.SymmetryEstimator;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

/**
 *
 * @author oslejsek
 */
public class SymmetryPlaneAction extends AbstractAction {
    
    public static final String ACTION_COMMAND_ON_OFF = "on-off";
    
    private final SymmetryPanel controlPanel = new SymmetryPanel();
    private final JPanel topControlPanel;
    private final Canvas canvas;
    
    private final SymmetryConfig config = new SymmetryConfig();
    private MeshFacet symmetryPlane = null;
    private CurvatureAlg curvatureAlg = CurvatureAlg.GAUSSIAN;
    
    public SymmetryPlaneAction(JPanel topControlPanel, Canvas canvas) {
        this.canvas = canvas;
        this.topControlPanel = topControlPanel;
        this.topControlPanel.add(controlPanel);
        controlPanel.setVisible(false);
    }
    
    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        switch (action) {
            case ACTION_COMMAND_ON_OFF:
                JToggleButton button = (JToggleButton) ae.getSource();
                if (button.isSelected()) {
                    controlPanel.setVisible(true);
                    if (symmetryPlane == null) {
                        recomputeSymmetryPlane();
                        //canvas.getScene().getDrawables().get(0)...
                    }
                } else {
                    controlPanel.setVisible(false);
                }
                break;
        }
        canvas.renderScene();
    }
    
    private void recomputeSymmetryPlane() {
        //setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
        SymmetryEstimator se = new SymmetryEstimator(this.config, this.curvatureAlg);
        canvas.getScene().getDrawables().get(0).getModel().compute(se);
        this.symmetryPlane = se.getSymmetryPlaneMesh();
    }
        
}
