package cz.fidentis.analyst.gui.rndtoolbar;

import cz.fidentis.analyst.gui.canvas.Canvas;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openide.util.NbBundle;

/**
 * A toolbar extension for a single face analysis.
 * 
 * @author Radek Oslejsek
 */
public class SingleFaceToolBar extends RenderingToolBar {
    
    /**
     * Constructor.
     * @param canvas Rendering canvas
     */
    public SingleFaceToolBar(Canvas canvas, JPanel controlPanel) {
        super(canvas);
        addSymmetryPlaneButton(controlPanel);
    }
    
    private void addSymmetryPlaneButton(JPanel controlPanel) {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new SymmetryPlaneAction(controlPanel, getCanvas()));
        button.setActionCommand(SymmetryPlaneAction.ACTION_COMMAND_ON_OFF);
        //button.setAction(new SymmetryPlaneAction(controlPanel));
        button.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.BACKGROUND_BUTTON_ICON)));
        button.setFocusable(false);
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "SingleFaceToolBar.symmetry.text"));
        add(button);
    }
}
