package cz.fidentis.analyst.gui.rndtoolbar;

import cz.fidentis.analyst.gui.canvas.Canvas;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.NbBundle;

/**
 * Generic rendering toolbar with common tools.
 * 
 * @author Radek Oslejsek
 */
public class RenderingToolBar extends JToolBar {
    
    public static final int WIDTH = 58;
    public static final Color REFLECTIONS_COLOR = Color.DARK_GRAY;
    
    public static final String RENDERING_MODE_BUTTON_ICON = "wireframe28x28.png";
    public static final String BACKGROUND_BUTTON_ICON = "background28x28.png";
    public static final String REFLECTIONS_BUTTON_ICON = "reflections28x28.png";
    public static final String SMOOT_BUTTON_ICON = "smooth-tri28x28.png";
    public static final String WIREFRAME_BUTTON_ICON = "wireframe-tri28x28.png";
    public static final String POINTS_BUTTON_ICON = "points-tri28x28.png";
    
    private final Canvas canvas;
    
    /**
     * Constructor.
     * @param canvas Rendering canvas
     */
    public RenderingToolBar(Canvas canvas) {
        this.canvas = canvas;
        initToolBar();
        addRenderingModeButton();
        addBackgroundButton();
        addReflectionsButton();
    }
    
    protected Canvas getCanvas() {
        return canvas;
    }
    
    private void initToolBar() {
        setOrientation(javax.swing.SwingConstants.VERTICAL);
        setRollover(true);
        setFloatable(false);
    }
    
    private void addRenderingModeButton() {
        JPopupMenu popup = new JPopupMenu();
        
        //JMenuItem menuItem1 = new JMenuItem(new RenderingModeAction(canvas));
        //JMenuItem menuItem2 = new JMenuItem(new WireframeRenderingAction(canvas));
        //JMenuItem menuItem3 = new JMenuItem(new PointCloudRenderingAction(canvas));
        
        JMenuItem menuItem1 = new JMenuItem(new RenderingModeAction(canvas));
        JMenuItem menuItem2 = new JMenuItem(new RenderingModeAction(canvas));
        JMenuItem menuItem3 = new JMenuItem(new RenderingModeAction(canvas));
        
        menuItem1.setActionCommand(RenderingModeAction.ACTION_COMMAND_SMOOTH_MODE);
        menuItem2.setActionCommand(RenderingModeAction.ACTION_COMMAND_WIREFRAME_MODE);
        menuItem3.setActionCommand(RenderingModeAction.ACTION_COMMAND_POINT_CLOUD_MODE);
        
        menuItem1.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.SMOOT_BUTTON_ICON)));
        menuItem2.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.WIREFRAME_BUTTON_ICON)));
        menuItem3.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.POINTS_BUTTON_ICON)));

        menuItem1.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.smooth.text"));
        menuItem2.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.wireframe.text"));
        menuItem3.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.pointcloud.text"));
        
        popup.add(menuItem1);
        popup.add(menuItem2);
        popup.add(menuItem3);
        
        popup.setLayout(new GridLayout(1,0));

        // The button that will display the default action and the
        // dropdown arrow
        JButton button = DropDownButtonFactory.createDropDownButton(
                new ImageIcon(new BufferedImage(16, 16, BufferedImage.TYPE_INT_ARGB)), 
                popup);
        
        button.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.RENDERING_MODE_BUTTON_ICON)));
        
        //Mnemonics.setLocalizedText(button, NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.renderingmode.text"));
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.renderingmode.text"));
        button.setFocusable(false);
        //button.setText(null);
        add(button);
    }
    
    private void addBackgroundButton() {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new RenderingModeAction(canvas));
        button.setActionCommand(RenderingModeAction.ACTION_COMMAND_BACKGROUND_CHANGE);
        //button.setAction(new BackgroundAction(canvas));
        button.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.BACKGROUND_BUTTON_ICON)));
        //Mnemonics.setLocalizedText(button, NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.background.text"));
        button.setFocusable(false);
       // button.setText(null);
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.background.text"));
        add(button);
    }
    
    private void addReflectionsButton() {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new RenderingModeAction(canvas));
        button.setActionCommand(RenderingModeAction.ACTION_COMMAND_REFLECTIONS_ON_OFF);
        //button.setAction(new ReflectionsAction(canvas));
        button.setIcon(new ImageIcon(getClass().getResource("/" + RenderingToolBar.REFLECTIONS_BUTTON_ICON)));
        //Mnemonics.setLocalizedText(button, NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.background.text"));
        button.setFocusable(false);
       // button.setText(null);
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar.reflections.text"));
        add(button);
    }
 
}
