package cz.fidentis.analyst.gui.rndtoolbar;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.gui.canvas.Canvas;
import static cz.fidentis.analyst.gui.rndtoolbar.RenderingToolBar.REFLECTIONS_COLOR;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JToggleButton;

/**
 * Action listener form OpenGL canvas rendering modes.
 * 
 * @author Radek Oslejsek
 */
public class RenderingModeAction extends AbstractAction {
    
    public static final String ACTION_COMMAND_SMOOTH_MODE = "smooth";
    public static final String ACTION_COMMAND_WIREFRAME_MODE = "wireframe";
    public static final String ACTION_COMMAND_POINT_CLOUD_MODE = "point cloud";
    public static final String ACTION_COMMAND_BACKGROUND_CHANGE = "background";
    public static final String ACTION_COMMAND_REFLECTIONS_ON_OFF = "reflections";
    
    
    private final Canvas canvas;
    
    /**
     * Constructor.
     * @param canvas OpenGL canvas
     */
    public RenderingModeAction(Canvas canvas) {
        this.canvas = canvas;
    }
    
    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        switch (action) {
            case ACTION_COMMAND_SMOOTH_MODE:
                for (DrawableMesh dm: canvas.getScene().getDrawables()) {
                   dm.setRenderMode(GL2.GL_FILL);
                }
                break;
            case ACTION_COMMAND_WIREFRAME_MODE:
                for (DrawableMesh dm: canvas.getScene().getDrawables()) {
                   dm.setRenderMode(GL2.GL_LINE);
                }
                break;
            case ACTION_COMMAND_POINT_CLOUD_MODE:
                for (DrawableMesh dm: canvas.getScene().getDrawables()) {
                   dm.setRenderMode(GL2.GL_POINT);
                }
                break;
            case ACTION_COMMAND_BACKGROUND_CHANGE:
                JToggleButton button1 = (JToggleButton) ae.getSource();
                if (button1.isSelected()) {
                    canvas.getSceneRenderer().setBrightBackground();
                } else {
                    canvas.getSceneRenderer().setDarkBackground();
                }
                break;
            case ACTION_COMMAND_REFLECTIONS_ON_OFF:
                JToggleButton button2 = (JToggleButton) ae.getSource();
                for (DrawableMesh dm: canvas.getScene().getDrawables()) {
                    if (button2.isSelected()) {
                        dm.setHighlights(REFLECTIONS_COLOR);
                    } else {
                        dm.setHighlights(Color.BLACK);
                    }
                }
                break;
        }
        canvas.renderScene();
    }
    
}
