package cz.fidentis.analyst.gui.canvas;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.gui.scene.Camera;
import cz.fidentis.analyst.gui.scene.Scene;
import cz.fidentis.analyst.gui.scene.SceneRenderer;

import java.awt.Color;
import java.awt.Cursor;

/**
 * OpenGL canvas.
 * 
 * @author Natalia Bebjakova 
 * @author Radek Oslejsek
 */
public class Canvas extends javax.swing.JPanel {
    
    private final GLCanvas glCanvas;
    private final SceneRenderer sceneRenderer;
    private final Camera camera = new Camera();
    private Scene scene;
    
    // Listeners:
    private final CanvasListener listener;
    private final MouseRotationListener manipulator;
    private final RotationAnimator animator;
    
    
    /**
     * Constructor.
     */
    public Canvas() {
        initComponents();
        
        // gl version 2 is used
        GLCapabilities capabilities = new GLCapabilities(GLProfile.get(GLProfile.GL2));
        capabilities.setDoubleBuffered(true);
       
        // creates new glCanvas panel for displaying model
        glCanvas = new GLCanvas(capabilities);
        jPanel1.add(glCanvas);
        glCanvas.setVisible(true);     
        glCanvas.setBackground(Color.black);
        
        // enables glCanvas to react to events
        glCanvas.requestFocusInWindow();        
        glCanvas.setSize(getWidth() - getInsets().left - getInsets().right, getHeight() - getInsets().top - getInsets().bottom);
       
        sceneRenderer = new SceneRenderer();
        
        //animator = new RotationAnimator(this.glCanvas, this.camera);
        animator = new RotationAnimator(this.glCanvas);
        
        listener = new CanvasListener(this);
        glCanvas.addGLEventListener(listener);
        
        manipulator = new MouseRotationListener(this);
        glCanvas.addMouseListener(manipulator);
        glCanvas.addMouseMotionListener(manipulator);
        glCanvas.addMouseWheelListener(manipulator);
        
        this.validate();   
    }
    
    /**
     * Initializes the scene for a single face. Can be called only once.
     * 
     * @param face Human face
     * @throws UnsupportedOperationException the the scene is already initiated
     * @throws IllegalArgumentException if the face is missing
     */
    public void initScene(HumanFace face) {
        if (scene != null) {
            throw new UnsupportedOperationException("Scene already exists");
        }
        this.scene = new Scene(face);
    }
    
    /**
     * Initializes the scene for the 1:1 comparison. Can be called only once.
     * 
     * @param face Human face
     * @throws UnsupportedOperationException the the scene is already initiated
     * @throws IllegalArgumentException if some face is missing
     */
    public void initScene(HumanFace primary, HumanFace secondary) {
        if (scene != null) {
            throw new UnsupportedOperationException("Scene already exists");
        }
        this.scene = new Scene(primary, secondary);
    }
   
    /**
     * Returns the scene
     * @return the scene
     */
    public SceneRenderer getSceneRenderer() {
        return sceneRenderer;
    }
    
    public void renderScene() {
        glCanvas.display();
    }
    
    /**
     * Returns the scene. 
     * 
     * @return the scene.
     */
    public Scene getScene() {
        return scene;
    }
    
    /**
     * Returns camera. 
     * 
     * @return camera
     */
    public Camera getCamera() {
        return camera;
    }
    
    /**
     * Returns the underlying OpenGL canvas.
     * 
     * @return the underlying OpenGL canvas.
     */
    /*
    public GLCanvas getGLCanvas() {
        return this.glCanvas;
    }*/
    
    
    /**
     * Changing the size of glCanvas
     * 
     * @param d New size of glCanvas
     */
    /*
    public void resizeCanvas(Dimension d) {
        jPanel1.setSize(d);
        glCanvas.setSize(d);
        this.validate();
        this.repaint();
    }
    */
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     * 
     * Generated code from NetBeans
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLayeredPane1 = new javax.swing.JLayeredPane();
        resetButton = new javax.swing.JLabel();
        upNavigationButton = new javax.swing.JButton();
        leftNavigationButton = new javax.swing.JButton();
        minusNavigationButton = new javax.swing.JButton();
        downNavigationButton = new javax.swing.JButton();
        plusNavigationButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        rightNavigationButton1 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();

        setBackground(new java.awt.Color(0, 0, 0));
        setLayout(new java.awt.BorderLayout());

        jLayeredPane1.setBackground(new java.awt.Color(40, 40, 40));
        jLayeredPane1.setToolTipText("");
        jLayeredPane1.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jLayeredPane1ComponentResized(evt);
            }
            public void componentShown(java.awt.event.ComponentEvent evt) {
                jLayeredPane1ComponentShown(evt);
            }
        });

        resetButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resetButton.png"))); // NOI18N
        resetButton.setToolTipText("Reset position of model");
        resetButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        resetButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                resetButtonMouseMoved(evt);
            }
        });
        resetButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                resetButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                resetButtonMouseExited(evt);
            }
        });
        jLayeredPane1.add(resetButton);
        resetButton.setBounds(60, 40, 30, 30);

        upNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/upButton.png"))); // NOI18N
        upNavigationButton.setToolTipText("Rotate up");
        upNavigationButton.setBorderPainted(false);
        upNavigationButton.setContentAreaFilled(false);
        upNavigationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        upNavigationButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                upNavigationButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                upNavigationButtonMouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(upNavigationButton, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(upNavigationButton);
        upNavigationButton.setBounds(60, 10, 30, 30);

        leftNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/leftButton.png"))); // NOI18N
        leftNavigationButton.setToolTipText("Rotate left");
        leftNavigationButton.setBorderPainted(false);
        leftNavigationButton.setContentAreaFilled(false);
        leftNavigationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        leftNavigationButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftNavigationButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftNavigationButtonMouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(leftNavigationButton, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(leftNavigationButton);
        leftNavigationButton.setBounds(30, 40, 30, 30);

        minusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/minus.png"))); // NOI18N
        minusNavigationButton.setToolTipText("Zoom out");
        minusNavigationButton.setBorderPainted(false);
        minusNavigationButton.setContentAreaFilled(false);
        minusNavigationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        minusNavigationButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                minusNavigationButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                minusNavigationButtonMouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(minusNavigationButton, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(minusNavigationButton);
        minusNavigationButton.setBounds(90, 90, 30, 30);

        downNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/downButton.png"))); // NOI18N
        downNavigationButton.setToolTipText("Rotate down");
        downNavigationButton.setBorderPainted(false);
        downNavigationButton.setContentAreaFilled(false);
        downNavigationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        downNavigationButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                downNavigationButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                downNavigationButtonMouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(downNavigationButton, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(downNavigationButton);
        downNavigationButton.setBounds(60, 70, 30, 30);

        plusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/plus.png"))); // NOI18N
        plusNavigationButton.setToolTipText("Zoom in");
        plusNavigationButton.setBorderPainted(false);
        plusNavigationButton.setContentAreaFilled(false);
        plusNavigationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        plusNavigationButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                plusNavigationButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                plusNavigationButtonMouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(plusNavigationButton, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(plusNavigationButton);
        plusNavigationButton.setBounds(30, 90, 30, 30);

        jLabel1.setBackground(new java.awt.Color(40, 40, 40));
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/navigBackground.png"))); // NOI18N
        jLayeredPane1.add(jLabel1);
        jLabel1.setBounds(30, 10, 90, 90);

        rightNavigationButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/rightButton.png"))); // NOI18N
        rightNavigationButton1.setToolTipText("Rotate right");
        rightNavigationButton1.setBorderPainted(false);
        rightNavigationButton1.setContentAreaFilled(false);
        rightNavigationButton1.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        rightNavigationButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightNavigationButton1MousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightNavigationButton1MouseReleased(evt);
            }
        });
        jLayeredPane1.setLayer(rightNavigationButton1, javax.swing.JLayeredPane.MODAL_LAYER);
        jLayeredPane1.add(rightNavigationButton1);
        rightNavigationButton1.setBounds(90, 40, 30, 30);

        jPanel1.setBackground(new java.awt.Color(0, 0, 0));
        jPanel1.setLayout(new java.awt.BorderLayout());
        jLayeredPane1.add(jPanel1);
        jPanel1.setBounds(0, 0, 0, 0);

        add(jLayeredPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jLayeredPane1ComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jLayeredPane1ComponentResized
        jPanel1.setBounds(0, 0, jLayeredPane1.getWidth(), jLayeredPane1.getHeight());
        glCanvas.setBounds(jLayeredPane1.getX(), jLayeredPane1.getY(), jLayeredPane1.getWidth(), jLayeredPane1.getHeight());
    }//GEN-LAST:event_jLayeredPane1ComponentResized

    private void jLayeredPane1ComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jLayeredPane1ComponentShown
        jPanel1.setBounds(0, 0, jLayeredPane1.getWidth(), jLayeredPane1.getHeight());
        glCanvas.setBounds(jLayeredPane1.getX(), jLayeredPane1.getY(), jLayeredPane1.getWidth(), jLayeredPane1.getHeight());
    }//GEN-LAST:event_jLayeredPane1ComponentShown

    private void leftNavigationButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftNavigationButtonMousePressed
        animator.startAnimation(Direction.ROTATE_LEFT, this.camera);
        leftNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/leftButtonPressed.png")));
    }//GEN-LAST:event_leftNavigationButtonMousePressed

    private void upNavigationButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_upNavigationButtonMousePressed
        animator.startAnimation(Direction.ROTATE_UP, this.camera);
        upNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/upButtonPressed.png")));
    }//GEN-LAST:event_upNavigationButtonMousePressed

    private void downNavigationButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_downNavigationButtonMousePressed
        animator.startAnimation(Direction.ROTATE_DOWN, this.camera);
        downNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/downButtonPressed.png")));
    }//GEN-LAST:event_downNavigationButtonMousePressed

    private void plusNavigationButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plusNavigationButtonMousePressed
        animator.startAnimation(Direction.ZOOM_IN, this.camera);
        plusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/plusPressed.png")));
    }//GEN-LAST:event_plusNavigationButtonMousePressed
 
    private void minusNavigationButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minusNavigationButtonMousePressed
        animator.startAnimation(Direction.ZOOM_OUT, this.camera);
        minusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/minusPressed.png")));
    }//GEN-LAST:event_minusNavigationButtonMousePressed

    private void leftNavigationButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftNavigationButtonMouseReleased
        animator.stopAnimation(this.camera);
        leftNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/leftButton.png")));
    }//GEN-LAST:event_leftNavigationButtonMouseReleased

    private void upNavigationButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_upNavigationButtonMouseReleased
        animator.stopAnimation(this.camera);
        upNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/upButton.png")));
    }//GEN-LAST:event_upNavigationButtonMouseReleased

    private void downNavigationButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_downNavigationButtonMouseReleased
        animator.stopAnimation(this.camera);
        downNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/downButton.png")));
    }//GEN-LAST:event_downNavigationButtonMouseReleased

    private void plusNavigationButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plusNavigationButtonMouseReleased
        animator.stopAnimation(this.camera);
        plusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/plus.png")));
    }//GEN-LAST:event_plusNavigationButtonMouseReleased

    private void minusNavigationButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minusNavigationButtonMouseReleased
        animator.stopAnimation(this.camera);
        minusNavigationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/minus.png")));
    }//GEN-LAST:event_minusNavigationButtonMouseReleased

    private void rightNavigationButton1MousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightNavigationButton1MousePressed
        animator.startAnimation(Direction.ROTATE_RIGHT, this.camera);
        rightNavigationButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/rightButtonPressed.png")));
    }//GEN-LAST:event_rightNavigationButton1MousePressed

    private void rightNavigationButton1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightNavigationButton1MouseReleased
        animator.stopAnimation(this.camera);
        rightNavigationButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/rightButton.png")));
    }//GEN-LAST:event_rightNavigationButton1MouseReleased

    private void resetButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resetButtonMouseClicked
        camera.initLocation();
        renderScene();
    }//GEN-LAST:event_resetButtonMouseClicked

    private void resetButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resetButtonMouseMoved
        resetButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resetButtonPressed.png")));
        resetButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }//GEN-LAST:event_resetButtonMouseMoved

    private void resetButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resetButtonMouseExited
        resetButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resetButton.png")));
    }//GEN-LAST:event_resetButtonMouseExited

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton downNavigationButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLayeredPane jLayeredPane1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton leftNavigationButton;
    private javax.swing.JButton minusNavigationButton;
    private javax.swing.JButton plusNavigationButton;
    private javax.swing.JLabel resetButton;
    private javax.swing.JButton rightNavigationButton1;
    private javax.swing.JButton upNavigationButton;
    // End of variables declaration//GEN-END:variables
}
