package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.project.ProjectPanel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.modules.ModuleInstall;

/**
 * GUI initialization class.
 * 
 * @author Radek Oslejsek
 */
public class Installer extends ModuleInstall {
    
    @Override
    public void restored() {
        /*
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                //System.out.println(info.getName());
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Installer.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        */
        java.awt.EventQueue.invokeLater(() -> {
            //old JFrame, disabled
            /*frameMain = new UserInterface();
            frameMain.setBackground(new Color(49,165,154));
            frameMain.pack();
            frameMain.setVisible(true);*/          
            //enables to use design of operating system
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }catch(ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            }
        });
    }
    
    @Override
    public boolean closing() {
        
        int answer = JOptionPane.showConfirmDialog(null,
                "Do you really want to close the application?", "", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        
        if (answer == JOptionPane.YES_OPTION) {
            ProjectPanel.serializeTasks();
        }
        
        return answer == JOptionPane.YES_OPTION;
    }

    
}
